/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.common.HeliosRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public abstract class Resolver {
    private static final String SRV_FORMAT = Resolver.env("HELIOS_SRV_FORMAT", "_%s._http.%s");
    private static final Logger log = LoggerFactory.getLogger(Resolver.class);

    private static String env(String name, String defaultValue) {
        return (String)Optional.fromNullable((Object)System.getenv(name)).or((Object)defaultValue);
    }

    public static Supplier<List<URI>> supplier(final String srvName, final String domain) {
        return new Supplier<List<URI>>(){

            public List<URI> get() {
                return Resolver.resolve(srvName, domain);
            }
        };
    }

    public static List<URI> resolve(String srvName, String domain) {
        Lookup lookup;
        String name = Resolver.srv(srvName, domain);
        try {
            lookup = new Lookup(name, 33, 1);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("unable to create lookup for name: " + name, e);
        }
        Record[] queryResult = lookup.run();
        switch (lookup.getResult()) {
            case 0: {
                ImmutableList.Builder endpoints = ImmutableList.builder();
                for (Record record : queryResult) {
                    if (!(record instanceof SRVRecord)) continue;
                    SRVRecord srv = (SRVRecord)record;
                    endpoints.add((Object)Resolver.http(srv.getTarget().toString(), srv.getPort()));
                }
                return endpoints.build();
            }
            case 3: 
            case 4: {
                log.warn("No results returned for query '{}'", (Object)name);
                return ImmutableList.of();
            }
        }
        throw new HeliosRuntimeException(String.format("Lookup of '%s' failed with code: %d - %s ", name, lookup.getResult(), lookup.getErrorString()));
    }

    private static URI http(String host, int port) {
        URI endpoint;
        try {
            endpoint = new URI("http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return endpoint;
    }

    private static String srv(String name, String domain) {
        return String.format(SRV_FORMAT, name, domain);
    }
}

