/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Deployment
extends Descriptor {
    public static final String EMTPY_DEPLOYER_USER = null;
    public static final String EMPTY_DEPLOYER_MASTER = null;
    public static final String EMPTY_DEPLOYMENT_GROUP_NAME = null;
    private final JobId jobId;
    private final Goal goal;
    private final String deployerUser;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String deployerMaster;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String deploymentGroupName;

    public Deployment(@JsonProperty(value="job") JobId jobId, @JsonProperty(value="goal") Goal goal, @JsonProperty(value="deployerUser") @Nullable String deployerUser, @JsonProperty(value="deployerMaster") @Nullable String deployerMaster, @JsonProperty(value="deploymentGroupName") @Nullable String deploymentGroupName) {
        this.jobId = jobId;
        this.goal = goal;
        this.deployerUser = deployerUser;
        this.deploymentGroupName = deploymentGroupName;
        this.deployerMaster = deployerMaster;
    }

    public static Deployment of(JobId jobId, Goal goal) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).build();
    }

    public static Deployment of(JobId jobId, Goal goal, String deployerUser) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).setDeployerUser(deployerUser).build();
    }

    public static Deployment of(JobId jobId, Goal goal, String deployerUser, String deployerMaster, String deploymentGroupName) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).setDeployerUser(deployerUser).setDeployerMaster(deployerMaster).setDeploymentGroupName(deploymentGroupName).build();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public String getDeployerUser() {
        return this.deployerUser;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String getDeployerMaster() {
        return this.deployerMaster;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("jobId", (Object)this.jobId).add("goal", (Object)this.goal).add("deployerUser", (Object)this.deployerUser).add("deployerMaster", (Object)this.deployerMaster).add("deploymentGroupName", (Object)this.deploymentGroupName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment that = (Deployment)o;
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.goal != that.goal) {
            return false;
        }
        if (this.deployerUser != null ? !this.deployerUser.equals(that.deployerUser) : that.deployerUser != null) {
            return false;
        }
        if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(that.deploymentGroupName) : that.deploymentGroupName != null) {
            return false;
        }
        return !(this.deployerMaster == null ? that.deployerMaster != null : !this.deployerMaster.equals(that.deployerMaster));
    }

    public int hashCode() {
        int result = this.jobId != null ? this.jobId.hashCode() : 0;
        result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
        result = 31 * result + (this.deployerUser != null ? this.deployerUser.hashCode() : 0);
        result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
        result = 31 * result + (this.deployerMaster != null ? this.deployerMaster.hashCode() : 0);
        return result;
    }

    public Builder toBuilder() {
        return Deployment.newBuilder().setDeployerUser(this.deployerUser).setGoal(this.goal).setJobId(this.jobId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private JobId jobId;
        private Goal goal;
        private String deployerUser;
        private String deployerMaster;
        private String deploymentGroupName;

        public Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setGoal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public Builder setDeployerUser(String deployerUser) {
            this.deployerUser = deployerUser;
            return this;
        }

        public Builder setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public Builder setDeployerMaster(String deployerMaster) {
            this.deployerMaster = deployerMaster;
            return this;
        }

        public Deployment build() {
            return new Deployment(this.jobId, this.goal, this.deployerUser, this.deployerMaster, this.deploymentGroupName);
        }
    }
}

