/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.HostSelector;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.RolloutOptions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentGroup
extends Descriptor {
    public static final String EMPTY_NAME = "";
    public static final JobId EMPTY_JOB_ID = null;
    private final String name;
    private final List<HostSelector> hostSelectors;
    private final JobId jobId;
    private final RolloutOptions rolloutOptions;

    public DeploymentGroup(@JsonProperty(value="name") String name, @JsonProperty(value="hostSelectors") List<HostSelector> hostSelectors, @JsonProperty(value="job") @Nullable JobId jobId, @JsonProperty(value="rolloutOptions") @Nullable RolloutOptions rolloutOptions) {
        this.name = name;
        this.hostSelectors = hostSelectors;
        this.jobId = jobId;
        this.rolloutOptions = rolloutOptions;
    }

    public String getName() {
        return this.name;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public List<HostSelector> getHostSelectors() {
        return this.hostSelectors;
    }

    public RolloutOptions getRolloutOptions() {
        return this.rolloutOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroup that = (DeploymentGroup)o;
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.hostSelectors != null ? !this.hostSelectors.equals(that.hostSelectors) : that.hostSelectors != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.rolloutOptions != null ? !this.rolloutOptions.equals(that.rolloutOptions) : that.rolloutOptions != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.hostSelectors != null ? this.hostSelectors.hashCode() : 0);
        result = 31 * result + (this.jobId != null ? this.jobId.hashCode() : 0);
        result = 31 * result + (this.rolloutOptions != null ? this.rolloutOptions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DeploymentGroup{name='" + this.name + '\'' + ", hostSelectors=" + this.hostSelectors + ", job=" + this.jobId + ", rolloutOptions=" + this.rolloutOptions + '}';
    }

    public Builder toBuilder() {
        Builder builder = DeploymentGroup.newBuilder();
        return builder.setName(this.name).setJobId(this.jobId).setHostSelectors(this.hostSelectors).setRolloutOptions(this.rolloutOptions);
    }

    public static class Builder
    implements Cloneable {
        private final Parameters p = new Parameters();

        private Builder() {
        }

        public String getName() {
            return this.p.name;
        }

        public Builder setName(String name) {
            this.p.name = name;
            return this;
        }

        public JobId getJobId() {
            return this.p.jobId;
        }

        public Builder setJobId(JobId jobId) {
            this.p.jobId = jobId;
            return this;
        }

        public List<HostSelector> getHostSelectors() {
            return this.p.hostSelectors;
        }

        public Builder setHostSelectors(List<HostSelector> hostSelectors) {
            this.p.hostSelectors = Lists.newArrayList(hostSelectors);
            return this;
        }

        public RolloutOptions getRolloutOptions() {
            return this.p.rolloutOptions;
        }

        public Builder setRolloutOptions(RolloutOptions rolloutOptions) {
            this.p.rolloutOptions = rolloutOptions;
            return this;
        }

        public DeploymentGroup build() {
            return new DeploymentGroup(this.p.name, this.p.hostSelectors, this.p.jobId, this.p.rolloutOptions);
        }

        private static class Parameters
        implements Cloneable {
            public String name = "";
            public JobId jobId = EMPTY_JOB_ID;
            public List<HostSelector> hostSelectors = Collections.emptyList();
            public RolloutOptions rolloutOptions = null;

            private Parameters() {
            }
        }
    }
}

