/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.RolloutTask;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(value={"version"}, ignoreUnknown=true)
public class DeploymentGroupStatus
extends Descriptor {
    private final DeploymentGroup deploymentGroup;
    private final State state;
    private final List<RolloutTask> rolloutTasks;
    private final int taskIndex;
    private final int successfulIterations;
    private final int version;
    private final String error;

    private DeploymentGroupStatus(@JsonProperty(value="deploymentGroup") DeploymentGroup deploymentGroup, @JsonProperty(value="state") State state, @JsonProperty(value="rolloutTasks") List<RolloutTask> rolloutTasks, @JsonProperty(value="taskIndex") int taskIndex, @JsonProperty(value="successfulIterations") int successfulIterations, @JsonProperty(value="error") String error, @JsonProperty(value="version") int version) {
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)deploymentGroup, (Object)"deploymentGroup");
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.rolloutTasks = (List)Preconditions.checkNotNull(rolloutTasks, (Object)"rolloutTasks");
        this.taskIndex = taskIndex;
        this.successfulIterations = successfulIterations;
        this.error = error;
        this.version = version;
    }

    public Builder toBuilder() {
        return DeploymentGroupStatus.newBuilder().setDeploymentGroup(this.deploymentGroup).setState(this.state).setRolloutTasks(this.rolloutTasks).setTaskIndex(this.taskIndex).setSuccessfulIterations(this.successfulIterations).setError(this.error).setVersion(this.version);
    }

    private DeploymentGroupStatus(Builder builder) {
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)builder.deploymentGroup, (Object)"deploymentGroup");
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)builder.state), (Object)"state"));
        this.rolloutTasks = (List)Preconditions.checkNotNull((Object)builder.rolloutTasks, (Object)"rolloutTasks");
        this.taskIndex = builder.taskIndex;
        this.successfulIterations = builder.successfulIterations;
        this.error = builder.error;
        this.version = builder.version;
    }

    public DeploymentGroup getDeploymentGroup() {
        return this.deploymentGroup;
    }

    public State getState() {
        return this.state;
    }

    public List<RolloutTask> getRolloutTasks() {
        return this.rolloutTasks;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public int getSuccessfulIterations() {
        return this.successfulIterations;
    }

    public String getError() {
        return this.error;
    }

    public int getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupStatus that = (DeploymentGroupStatus)o;
        if (this.successfulIterations != that.successfulIterations) {
            return false;
        }
        if (this.taskIndex != that.taskIndex) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.deploymentGroup != null ? !this.deploymentGroup.equals(that.deploymentGroup) : that.deploymentGroup != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.rolloutTasks != null ? !this.rolloutTasks.equals(that.rolloutTasks) : that.rolloutTasks != null) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.deploymentGroup != null ? this.deploymentGroup.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.rolloutTasks != null ? this.rolloutTasks.hashCode() : 0);
        result = 31 * result + this.taskIndex;
        result = 31 * result + this.successfulIterations;
        result = 31 * result + this.version;
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("deploymentGroup", (Object)this.deploymentGroup).add("state", (Object)this.state).add("rolloutTasks", this.rolloutTasks).add("taskIndex", this.taskIndex).add("error", (Object)this.error).add("version", this.version).add("successfulIterations", this.successfulIterations).toString();
    }

    public static class Builder {
        private DeploymentGroup deploymentGroup;
        private State state;
        private List<RolloutTask> rolloutTasks = Collections.emptyList();
        private int taskIndex;
        private int successfulIterations;
        private String error;
        private int version;

        public Builder setDeploymentGroup(DeploymentGroup deploymentGroup) {
            this.deploymentGroup = deploymentGroup;
            return this;
        }

        public Builder setState(State state) {
            this.state = state;
            return this;
        }

        public Builder setRolloutTasks(List<RolloutTask> rolloutTasks) {
            this.rolloutTasks = rolloutTasks;
            return this;
        }

        public Builder setTaskIndex(int taskIndex) {
            this.taskIndex = taskIndex;
            return this;
        }

        public Builder setSuccessfulIterations(int successfulIterations) {
            this.successfulIterations = successfulIterations;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public DeploymentGroupStatus build() {
            return new DeploymentGroupStatus(this);
        }
    }

    public static enum State {
        PLANNING_ROLLOUT,
        ROLLING_OUT,
        FAILED,
        DONE;

    }
}

