/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RolloutOptions {
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final int DEFAULT_PARALLELISM = 1;
    private final long timeout;
    private final int parallelism;
    private final boolean migrate;

    public RolloutOptions(@JsonProperty(value="timeout") long timeout, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="migrate") boolean migrate) {
        this.timeout = timeout;
        this.parallelism = parallelism;
        this.migrate = migrate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().setTimeout(this.timeout).setParallelism(this.parallelism).setMigrate(this.migrate);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getMigrate() {
        return this.migrate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloutOptions that = (RolloutOptions)o;
        if (this.migrate != that.migrate) {
            return false;
        }
        if (this.parallelism != that.parallelism) {
            return false;
        }
        return this.timeout == that.timeout;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.parallelism;
        result = 31 * result + (this.migrate ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RolloutOptions{timeout=" + this.timeout + ", parallelism=" + this.parallelism + ", migrate=" + this.migrate + '}';
    }

    public static class Builder {
        private long timeout = DEFAULT_TIMEOUT;
        private int parallelism = 1;
        private boolean migrate = false;

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder setMigrate(boolean migrate) {
            this.migrate = migrate;
            return this;
        }

        public RolloutOptions build() {
            return new RolloutOptions(this.timeout, this.parallelism, this.migrate);
        }
    }
}

