/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.helios.Polling;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AgentReportingTest
extends SystemTestBase {
    @Test
    public void verifyAgentReportsDockerVersion() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        final HeliosClient client = this.defaultClient();
        DockerVersion dockerVersion = (DockerVersion)Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<DockerVersion>(){

            @Override
            public DockerVersion call() throws Exception {
                HostStatus status = (HostStatus)client.hostStatus(AgentReportingTest.this.testHost()).get();
                return status == null ? null : (status.getHostInfo() == null ? null : status.getHostInfo().getDockerVersion());
            }
        });
        try (DockerClient dockerClient = this.getNewDockerClient();){
            String expectedDockerVersion = dockerClient.version().version();
            Assert.assertThat((Object)dockerVersion.getVersion(), (Matcher)Matchers.is((Object)expectedDockerVersion));
        }
    }
}

