/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.util.concurrent.Service;
import com.spotify.helios.ZooKeeperTestManager;
import com.spotify.helios.ZooKeeperTestingServerManager;
import com.spotify.helios.agent.AgentMain;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AgentStateDirConflictTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Thread.UncaughtExceptionHandler dueh;
    private Path stateDir;
    private AgentMain first;
    private AgentMain second;
    private ZooKeeperTestManager zk;

    @Before
    public void setup() throws Exception {
        this.zk = new ZooKeeperTestingServerManager();
        this.dueh = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        this.stateDir = Files.createTempDirectory("helios-agent-conflict-test", new FileAttribute[0]);
        this.first = this.makeAgent("first");
        this.second = this.makeAgent("second");
    }

    private AgentMain makeAgent(String name) throws ArgumentParserException {
        return new AgentMain(new String[]{"-vvvv", "--no-log-setup", "--no-http", "--name=" + name, "--zk=" + this.zk.connectString(), "--state-dir", this.stateDir.toString(), "--domain", ""});
    }

    @After
    public void teardown() throws Exception {
        FileUtils.deleteQuietly((File)this.stateDir.toFile());
        this.stopQuietly((Service)this.first);
        this.stopQuietly((Service)this.second);
        Thread.setDefaultUncaughtExceptionHandler(this.dueh);
        this.zk.stop();
    }

    private void stopQuietly(Service service) {
        if (service == null) {
            return;
        }
        try {
            service.stopAsync().awaitTerminated();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test() throws Exception {
        this.first.startAsync().awaitRunning();
        this.exception.expect(IllegalStateException.class);
        this.second.startAsync().awaitRunning();
    }
}

