/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.spotify.helios.Polling;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CliDeploymentTest
extends SystemTestBase {
    private static final JobId BOGUS_JOB = new JobId("bogus", "job", Strings.repeat((String)"0", (int)40));
    private static final String BOGUS_HOST = "BOGUS_HOST";
    private static final TypeReference<Map<JobId, JobStatus>> STATUSES_TYPE = new TypeReference<Map<JobId, JobStatus>>(){};
    private final Integer externalPort = this.temporaryPorts().localPort("external");

    @Test
    public void testDeployAndUndeployJob() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliDeploymentTest.this.cli("masters", new String[0]);
                return output.contains(CliDeploymentTest.this.masterName()) ? output : null;
            }
        });
        this.startDefaultAgent(this.testHost(), new String[0]);
        String image = "busybox:latest";
        ImmutableMap ports = ImmutableMap.of((Object)"foo", (Object)PortMapping.of((int)4711), (Object)"bar", (Object)PortMapping.of((int)5000, (Integer)this.externalPort));
        ImmutableMap registration = ImmutableMap.of((Object)ServiceEndpoint.of((String)"foo-service", (String)"tcp"), (Object)ServicePorts.of((String[])new String[]{"foo"}), (Object)ServiceEndpoint.of((String)"bar-service", (String)"http"), (Object)ServicePorts.of((String[])new String[]{"bar"}));
        ImmutableMap env = ImmutableMap.of((Object)"BAD", (Object)"f00d");
        this.awaitHostRegistered(this.testHost(), 400L, TimeUnit.SECONDS);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND, (Map<String, String>)env, (Map<String, PortMapping>)ports, (Map<ServiceEndpoint, ServicePorts>)registration);
        Job expected = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setCommand(IDLE_COMMAND).setEnv((Map)env).setPorts((Map)ports).setRegistration((Map)registration).setCreatingUser("test-user").build();
        String inspectOutput = this.cli("inspect", "--json", jobId.toString());
        Job parsed = (Job)Json.read((String)inspectOutput, Job.class);
        this.assertJobEquals(expected, parsed);
        MatcherAssert.assertThat((Object)this.cli("jobs", this.testJobName, "-q"), (Matcher)Matchers.containsString((String)jobId.toString()));
        MatcherAssert.assertThat((Object)this.cli("jobs", this.testJobName + ":" + this.testJobVersion, "-q"), (Matcher)Matchers.containsString((String)jobId.toString()));
        Assert.assertEquals((Object)"job pattern foozbarz matched no jobs", (Object)this.cli("jobs", "foozbarz").trim());
        Assert.assertTrue((boolean)this.cli("jobs", "foozbarz", "-q").isEmpty());
        Job expectedCloned = expected.toBuilder().setVersion(expected.getId().getVersion() + "-cloned").build();
        JobId clonedJobId = JobId.parse((String)CharMatcher.WHITESPACE.trimFrom((CharSequence)this.cli("create", "-q", "-t", this.testJobName + ":" + this.testJobVersion, this.testJobName + ":" + this.testJobVersion + "-cloned")));
        String clonedInspectOutput = this.cli("inspect", "--json", clonedJobId.toString());
        Job clonedParsed = (Job)Json.read((String)clonedInspectOutput, Job.class);
        Assert.assertEquals((Object)expectedCloned, (Object)clonedParsed);
        String statusString = this.cli("status", "--job", jobId.toString(), "--json");
        Map statuses = (Map)Json.read((String)statusString, STATUSES_TYPE);
        Job job = ((JobStatus)statuses.get(jobId)).getJob();
        Assert.assertEquals((Object)ServicePorts.of((String[])new String[]{"foo"}), job.getRegistration().get(ServiceEndpoint.of((String)"foo-service", (String)"tcp")));
        Assert.assertEquals((Object)ServicePorts.of((String[])new String[]{"bar"}), job.getRegistration().get(ServiceEndpoint.of((String)"bar-service", (String)"http")));
        Assert.assertEquals((long)4711L, (long)((PortMapping)job.getPorts().get("foo")).getInternalPort());
        Assert.assertEquals((Object)PortMapping.of((int)5000, (Integer)this.externalPort), job.getPorts().get("bar"));
        Assert.assertEquals((Object)"f00d", job.getEnv().get("BAD"));
        String duplicateJob = this.cli("create", this.testJobName + ":" + this.testJobVersion, "busybox:latest", "--", IDLE_COMMAND);
        MatcherAssert.assertThat((Object)duplicateJob, (Matcher)Matchers.containsString((String)"JOB_ALREADY_EXISTS"));
        String prestop = this.stopJob(jobId, this.testHost());
        MatcherAssert.assertThat((Object)prestop, (Matcher)Matchers.containsString((String)"JOB_NOT_DEPLOYED"));
        this.deployJob(jobId, this.testHost());
        String stop1 = this.stopJob(jobId, BOGUS_HOST);
        MatcherAssert.assertThat((Object)stop1, (Matcher)Matchers.containsString((String)"HOST_NOT_FOUND"));
        String stop2 = this.stopJob(BOGUS_JOB, this.testHost());
        MatcherAssert.assertThat((Object)stop2, (Matcher)Matchers.containsString((String)"Unknown job"));
        String stop3 = this.stopJob(jobId, this.testHost());
        MatcherAssert.assertThat((Object)stop3, (Matcher)Matchers.containsString((String)(this.testHost() + ": done")));
        MatcherAssert.assertThat((Object)this.cli("undeploy", jobId.toString(), BOGUS_HOST), (Matcher)Matchers.containsString((String)"HOST_NOT_FOUND"));
        MatcherAssert.assertThat((Object)this.cli("undeploy", BOGUS_JOB.toString(), this.testHost()), (Matcher)Matchers.containsString((String)"Unknown job"));
        this.undeployJob(jobId, this.testHost());
    }

    @Test
    public void testDeployingNonexistantJobJson() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliDeploymentTest.this.cli("masters", new String[0]);
                return output.contains(CliDeploymentTest.this.masterName()) ? output : null;
            }
        });
        String output = this.cli("deploy", "--json", BOGUS_JOB.toString(), this.testHost());
        JobDeployResponse jobDeployResponse = (JobDeployResponse)Json.read((String)output, JobDeployResponse.class);
        Assert.assertEquals((Object)JobDeployResponse.Status.JOB_NOT_FOUND, (Object)jobDeployResponse.getStatus());
    }

    @Test
    public void testDeployingNonexistantHostJson() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliDeploymentTest.this.cli("masters", new String[0]);
                return output.contains(CliDeploymentTest.this.masterName()) ? output : null;
            }
        });
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        String output = this.cli("deploy", "--json", jobId.toString(), BOGUS_HOST);
        JobDeployResponse jobDeployResponse = (JobDeployResponse)Json.read((String)output, JobDeployResponse.class);
        Assert.assertEquals((Object)JobDeployResponse.Status.HOST_NOT_FOUND, (Object)jobDeployResponse.getStatus());
    }

    @Test
    public void testUndeployingNonexistantJobJson() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliDeploymentTest.this.cli("masters", new String[0]);
                return output.contains(CliDeploymentTest.this.masterName()) ? output : null;
            }
        });
        String output = this.cli("undeploy", "--json", BOGUS_JOB.toString(), this.testHost());
        JobDeployResponse jobDeployResponse = (JobDeployResponse)Json.read((String)output, JobDeployResponse.class);
        Assert.assertEquals((Object)JobDeployResponse.Status.JOB_NOT_FOUND, (Object)jobDeployResponse.getStatus());
    }

    @Test
    public void testUndeployingNonexistantHostJson() throws Exception {
        this.startDefaultMaster(new String[0]);
        Polling.await((long)400L, (TimeUnit)TimeUnit.SECONDS, (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String output = CliDeploymentTest.this.cli("masters", new String[0]);
                return output.contains(CliDeploymentTest.this.masterName()) ? output : null;
            }
        });
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        String output = this.cli("undeploy", "--json", jobId.toString(), BOGUS_HOST);
        JobDeployResponse jobDeployResponse = (JobDeployResponse)Json.read((String)output, JobDeployResponse.class);
        Assert.assertEquals((Object)JobDeployResponse.Status.HOST_NOT_FOUND, (Object)jobDeployResponse.getStatus());
    }
}

