/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.spotify.helios.cli.CliMain;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.system.SystemTestBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class JobWatchExactTest
extends SystemTestBase {
    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND);
        this.deployJob(jobId, this.testHost());
        String[] commands = new String[]{"watch", "--exact", "-z", this.masterEndpoint(), "--no-log-setup", jobId.toString(), this.testHost(), "FAKE_TEST_AGENT"};
        final AtomicBoolean success = new AtomicBoolean(false);
        final ArrayList outputLines = Lists.newArrayList();
        final long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(400L);
        String testHost = this.testHost();
        final String abbreviatedTestHost = testHost.length() > 10 ? testHost.substring(0, 10) : testHost;
        OutputStream out = new OutputStream(){
            boolean seenKnownState;
            boolean seenUnknownAgent;
            int counter;
            final byte[] lineBuffer = new byte[8192];

            @Override
            public void write(int b) throws IOException {
                if (System.currentTimeMillis() > deadline) {
                    throw new IOException("timed out trying to succeed");
                }
                this.lineBuffer[this.counter] = (byte)b;
                ++this.counter;
                if (b != 10) {
                    return;
                }
                String line = Charsets.UTF_8.decode(ByteBuffer.wrap(this.lineBuffer, 0, this.counter)).toString();
                outputLines.add(line);
                this.counter = 0;
                if (line.contains(abbreviatedTestHost) && !line.contains("UNKNOWN")) {
                    this.seenKnownState = true;
                }
                if (line.contains("FAKE_TEST_AGENT") && line.contains("UNKNOWN")) {
                    this.seenUnknownAgent = true;
                }
                if (this.seenKnownState && this.seenUnknownAgent) {
                    success.set(true);
                    throw new IOException("output closed");
                }
            }
        };
        CliMain main = new CliMain(new PrintStream(out), new PrintStream(new ByteArrayOutputStream()), commands);
        main.run();
        Assert.assertTrue((String)("Should have stopped the stream due to success: got\n" + Joiner.on((String)"").join((Iterable)outputLines)), (boolean)success.get());
    }
}

