/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.system.SystemTestBase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class MultipleHostsTest
extends SystemTestBase {
    @Test
    public void testHostStatuses() throws Exception {
        String aHost = this.testHost() + "a";
        String bHost = this.testHost() + "b";
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(aHost, new String[0]);
        this.startDefaultAgent(bHost, new String[0]);
        this.awaitHostStatus(aHost, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.awaitHostStatus(bHost, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Map cliStatuses = (Map)new ObjectMapper().readValue(this.cli("hosts", "--json"), (TypeReference)new TypeReference<Map<String, HostStatus>>(){});
        Assert.assertTrue((String)("status must contain key for " + aHost), (boolean)cliStatuses.containsKey(aHost));
        Assert.assertTrue((String)("status must contain key for " + bHost), (boolean)cliStatuses.containsKey(bHost));
        HeliosClient client = this.defaultClient();
        Map clientStatuses = (Map)client.hostStatuses((List)ImmutableList.of((Object)aHost, (Object)bHost)).get();
        Assert.assertTrue((String)("status must contain key for " + aHost), (boolean)clientStatuses.containsKey(aHost));
        Assert.assertTrue((String)("status must contain key for " + bHost), (boolean)clientStatuses.containsKey(bHost));
    }

    @Test
    public void testFilteringJobAndHostStatuses() throws Exception {
        String aHost = this.testHost() + "a";
        String bHost = this.testHost() + "b";
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(aHost, new String[0]);
        this.startDefaultAgent(bHost, new String[0]);
        this.awaitHostStatus(aHost, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        this.awaitHostStatus(bHost, HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        HeliosClient client = this.defaultClient();
        Job job = Job.newBuilder().setName(this.testJobName + "I_WANT_THIS_ONE").setVersion(this.testJobVersion).setImage("busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId jobId = job.getId();
        client.createJob(job).get();
        Job job2 = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId jobId2 = job2.getId();
        client.createJob(job2).get();
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        client.deploy(deployment, aHost);
        client.deploy(deployment, bHost);
        client.deploy(Deployment.of((JobId)jobId2, (Goal)Goal.START), aHost);
        this.awaitJobState(client, aHost, jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.awaitJobState(client, bHost, jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.awaitJobState(client, aHost, jobId2, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        Map cliStatuses = (Map)new ObjectMapper().readValue(this.cli("status", "--job", "I_WANT_THIS_ONE", "--host", aHost, "--json"), (TypeReference)new TypeReference<Map<JobId, JobStatus>>(){});
        Assert.assertEquals((String)"status should only have one job", (long)1L, (long)cliStatuses.size());
        Assert.assertTrue((boolean)cliStatuses.containsKey(jobId));
        JobStatus status = (JobStatus)cliStatuses.get(jobId);
        Assert.assertEquals((String)"deployments should have only one item", (long)1L, (long)status.getDeployments().size());
        Assert.assertTrue((String)"should only have deployment info for aHost", (boolean)status.getDeployments().containsKey(aHost));
        Assert.assertEquals((String)"Task statuses should only have one item", (long)1L, (long)status.getTaskStatuses().size());
        Assert.assertTrue((String)"should only have status info for aHost", (boolean)status.getTaskStatuses().containsKey(aHost));
    }
}

