/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.Info;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.Resources;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ResourcesTest
extends SystemTestBase {
    private HeliosClient client;
    private Job job;
    private static final Long MEMORY = 0xA00000L;
    private static final Long MEMORY_SWAP = 0xA00003L;
    private static final Long CPU_SHARES = 512L;
    private static final String CPUSET = "0-1";

    @Before
    public void setup() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), new String[0]);
        this.job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setResources(new Resources(MEMORY, MEMORY_SWAP, CPU_SHARES, CPUSET)).setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        try (DockerClient docker = this.getNewDockerClient();){
            Info info = docker.info();
            Assume.assumeTrue((boolean)info.memoryLimit());
            Assume.assumeTrue((boolean)info.swapLimit());
        }
    }

    @Test
    public void testClient() throws Exception {
        CreateJobResponse created = (CreateJobResponse)this.client.createJob(this.job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        JobId jobId = this.job.getId();
        this.awaitHostRegistered(this.client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(this.client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START);
        JobDeployResponse deployed = (JobDeployResponse)this.client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        TaskStatus taskStatus = this.awaitJobState(this.client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        this.assertJobEquals(this.job, taskStatus.getJob());
        try (DockerClient docker = this.getNewDockerClient();){
            ContainerConfig containerConfig = docker.inspectContainer(taskStatus.getContainerId()).config();
            Assert.assertEquals((Object)MEMORY, (Object)containerConfig.memory());
            Assert.assertEquals((Object)MEMORY_SWAP, (Object)containerConfig.memorySwap());
            Assert.assertEquals((Object)CPU_SHARES, (Object)containerConfig.cpuShares());
            Assert.assertEquals((Object)CPUSET, (Object)containerConfig.cpuset());
        }
    }
}

