/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.Lists;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.common.protocol.SetGoalResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TokenTest
extends SystemTestBase {
    private static final String TOKEN = "--token=abc123";
    private static final String NO_TOKEN = null;
    private static final String WRONG_TOKEN = "--token=wrongToken";

    @Test
    public void testJobWithToken() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        CreateJobResponse createJobResponse = this.cliJson(CreateJobResponse.class, "create", TOKEN, this.testJobNameAndVersion, "busybox:latest");
        MatcherAssert.assertThat((Object)createJobResponse.getStatus(), (Matcher)Matchers.equalTo((Object)CreateJobResponse.Status.OK));
        this.deploy(NO_TOKEN, JobDeployResponse.Status.FORBIDDEN);
        this.deploy(WRONG_TOKEN, JobDeployResponse.Status.FORBIDDEN);
        this.deploy(TOKEN, JobDeployResponse.Status.OK);
        this.stop(NO_TOKEN, SetGoalResponse.Status.FORBIDDEN);
        this.stop(WRONG_TOKEN, SetGoalResponse.Status.FORBIDDEN);
        this.stop(TOKEN, SetGoalResponse.Status.OK);
        this.undeploy(NO_TOKEN, JobUndeployResponse.Status.FORBIDDEN);
        this.undeploy(WRONG_TOKEN, JobUndeployResponse.Status.FORBIDDEN);
        this.undeploy(TOKEN, JobUndeployResponse.Status.OK);
        this.remove(NO_TOKEN, JobDeleteResponse.Status.FORBIDDEN);
        this.remove(WRONG_TOKEN, JobDeleteResponse.Status.FORBIDDEN);
        this.remove(TOKEN, JobDeleteResponse.Status.OK);
    }

    @Test
    public void testJobWithoutToken() throws Exception {
        this.startDefaultMaster(new String[0]);
        this.startDefaultAgent(this.testHost(), new String[0]);
        HeliosClient client = this.defaultClient();
        this.awaitHostRegistered(client, this.testHost(), 400, TimeUnit.SECONDS);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        CreateJobResponse createJobResponse = this.cliJson(CreateJobResponse.class, "create", this.testJobNameAndVersion, "busybox:latest");
        MatcherAssert.assertThat((Object)createJobResponse.getStatus(), (Matcher)Matchers.equalTo((Object)CreateJobResponse.Status.OK));
        this.deploy(TOKEN, JobDeployResponse.Status.FORBIDDEN);
        this.deploy(NO_TOKEN, JobDeployResponse.Status.OK);
        this.stop(TOKEN, SetGoalResponse.Status.FORBIDDEN);
        this.stop(NO_TOKEN, SetGoalResponse.Status.OK);
        this.undeploy(TOKEN, JobUndeployResponse.Status.FORBIDDEN);
        this.undeploy(NO_TOKEN, JobUndeployResponse.Status.OK);
        this.remove(TOKEN, JobDeleteResponse.Status.FORBIDDEN);
        this.remove(NO_TOKEN, JobDeleteResponse.Status.OK);
    }

    private void deploy(String token, JobDeployResponse.Status status) throws Exception {
        List<String> args = this.buildArgs(token, this.testJobNameAndVersion, this.testHost());
        JobDeployResponse response = this.cliJson(JobDeployResponse.class, "deploy", args);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)status));
    }

    private void stop(String token, SetGoalResponse.Status status) throws Exception {
        List<String> args = this.buildArgs(token, this.testJobNameAndVersion, this.testHost());
        SetGoalResponse response = this.cliJson(SetGoalResponse.class, "stop", args);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)status));
    }

    private void undeploy(String token, JobUndeployResponse.Status status) throws Exception {
        List<String> args = this.buildArgs(token, this.testJobNameAndVersion, this.testHost());
        JobUndeployResponse response = this.cliJson(JobUndeployResponse.class, "undeploy", args);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)status));
    }

    private void remove(String token, JobDeleteResponse.Status status) throws Exception {
        List<String> args = this.buildArgs(token, "--yes", this.testJobNameAndVersion);
        JobDeleteResponse response = this.cliJson(JobDeleteResponse.class, "remove", args);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)status));
    }

    private List<String> buildArgs(String token, String ... args) {
        return token == null ? Arrays.asList(args) : Lists.asList((Object)token, (Object[])args);
    }
}

