/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.amazonclient;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AWSHandlerResolver
implements HandlerResolver {
    private final String awsSecretKey;

    public AWSHandlerResolver(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        QName serviceQName = portInfo.getServiceName();
        if (serviceQName.getLocalPart().equals("AWSECommerceService")) {
            handlerChain.add((Handler)new AwsHandler(this.awsSecretKey));
        }
        return handlerChain;
    }

    public static class AwsHandler
    implements SOAPHandler<SOAPMessageContext> {
        private final byte[] secretBytes;

        public AwsHandler(String awsSecretKey) {
            this.secretBytes = this.stringToUtf8(awsSecretKey);
        }

        public void close(MessageContext messagecontext) {
        }

        public Set<QName> getHeaders() {
            return null;
        }

        public boolean handleFault(SOAPMessageContext messagecontext) {
            return true;
        }

        public boolean handleMessage(SOAPMessageContext messagecontext) {
            Boolean outbound = (Boolean)messagecontext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound.booleanValue()) {
                try {
                    SOAPMessage soapMessage = messagecontext.getMessage();
                    SOAPBody soapBody = soapMessage.getSOAPBody();
                    Node firstChild = soapBody.getFirstChild();
                    String timeStamp = this.getTimestamp();
                    String signature = this.getSignature(firstChild.getLocalName(), timeStamp, this.secretBytes);
                    this.appendTextElement(firstChild, "Signature", signature);
                    this.appendTextElement(firstChild, "Timestamp", timeStamp);
                }
                catch (SOAPException se) {
                    throw new RuntimeException("SOAPException was thrown.", se);
                }
            }
            return true;
        }

        private String getSignature(String operation, String timeStamp, byte[] secretBytes) {
            try {
                String toSign = operation + timeStamp;
                byte[] toSignBytes = this.stringToUtf8(toSign);
                Mac signer = Mac.getInstance("HmacSHA256");
                SecretKeySpec keySpec = new SecretKeySpec(secretBytes, "HmacSHA256");
                signer.init(keySpec);
                signer.update(toSignBytes);
                byte[] signBytes = signer.doFinal();
                String signature = new String(Base64.encodeBase64((byte[])signBytes));
                return signature;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("NoSuchAlgorithmException was thrown.", nsae);
            }
            catch (InvalidKeyException ike) {
                throw new RuntimeException("InvalidKeyException was thrown.", ike);
            }
        }

        private String getTimestamp() {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.format(calendar.getTime());
        }

        private byte[] stringToUtf8(String source) {
            try {
                return source.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("getBytes threw an UnsupportedEncodingException", e);
            }
        }

        private void appendTextElement(Node node, String elementName, String elementText) {
            Element element = node.getOwnerDocument().createElement(elementName);
            element.setTextContent(elementText);
            node.appendChild(element);
        }
    }
}

