/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.amazonclient;

import at.molindo.amazonclient.AWSHandlerResolver;
import at.molindo.amazonclient.AmazonProductAdvertisingLocale;
import com.amazon.webservices.awsecommerceservice.AWSECommerceService;
import com.amazon.webservices.awsecommerceservice.AWSECommerceServicePortType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class AmazonClient {
    private AmazonClient() {
    }

    public static AWSECommerceService newService(String awsSecret) {
        if (awsSecret == null) {
            throw new IllegalStateException("awsSecretKey not configured");
        }
        AWSECommerceService svc = new AWSECommerceService();
        svc.setHandlerResolver(new AWSHandlerResolver(awsSecret));
        return svc;
    }

    public static void setEndpoint(AWSECommerceServicePortType port, AmazonProductAdvertisingLocale locale, boolean useHttps) {
        String endpoint;
        String string = endpoint = useHttps ? locale.getSecureEndpoint() : locale.getEndpoint();
        if (endpoint == null) {
            throw new IllegalArgumentException("can't create endpoit for locale " + (Object)((Object)locale) + " (useHttps=" + useHttps + ")");
        }
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
    }

    public static void enableCompression(AWSECommerceServicePortType port) {
        Map ctxt = ((BindingProvider)port).getRequestContext();
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        Map currentHeaders = (Map)ctxt.get("javax.xml.ws.http.request.headers");
        if (currentHeaders != null) {
            httpHeaders.putAll(currentHeaders);
        }
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        ctxt.put("javax.xml.ws.http.request.headers", httpHeaders);
    }
}

