/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import at.molindo.mysqlcollations.MySqlCharacterMap;
import at.molindo.mysqlcollations.MySqlCollation;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MySqlCharset
implements Serializable {
    static final int MAX_CHARACTERS = 256;
    private static final long serialVersionUID = 1L;
    private String _name;
    private MySqlCharacterMap _ctype;
    private MySqlCharacterMap _lower;
    private MySqlCharacterMap _upper;
    private MySqlCharacterMap _unicode;
    private Map<String, MySqlCollation> _collations;
    private transient Charset _charset;
    private transient char[] _charTable;
    private transient int[] _indexTable;

    private static int toBytes(int index, byte[] bytes) {
        int first = -1;
        for (int i = 0; i < bytes.length; ++i) {
            int b = index >> (3 - i) * 8;
            bytes[i] = (byte)(b & 0xFF);
            if (first >= 0 || bytes[i] == 0) continue;
            first = i;
        }
        return first;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public MySqlCharacterMap getCtype() {
        return this._ctype;
    }

    public void setCtype(MySqlCharacterMap ctype) {
        this._ctype = ctype;
    }

    public MySqlCharacterMap getLower() {
        return this._lower;
    }

    public void setLower(MySqlCharacterMap lower) {
        this._lower = lower;
    }

    public MySqlCharacterMap getUpper() {
        return this._upper;
    }

    public void setUpper(MySqlCharacterMap upper) {
        this._upper = upper;
    }

    public MySqlCharacterMap getUnicode() {
        return this._unicode;
    }

    public void setUnicode(MySqlCharacterMap unicode) {
        this._unicode = unicode;
    }

    public Map<String, MySqlCollation> getCollations() {
        return this._collations;
    }

    public void setCollations(Map<String, MySqlCollation> collations) {
        this._collations = collations;
    }

    public void add(MySqlCollation collation) {
        if (this._collations == null) {
            this._collations = new HashMap<String, MySqlCollation>();
        }
        if (this._collations.put(collation.getName(), collation) != null) {
            throw new IllegalArgumentException("duplicate collation name: " + collation.getName());
        }
        collation.setCharset(this);
    }

    boolean isUpperCaseWordChar(char character) {
        return (this.getCtypeValue(character) & 1) != 0;
    }

    boolean isLowerCaseWordChar(char character) {
        return (this.getCtypeValue(character) & 2) != 0;
    }

    boolean isDecimalDigit(char character) {
        return (this.getCtypeValue(character) & 4) != 0;
    }

    boolean isPrinterControl(char character) {
        return (this.getCtypeValue(character) & 8) != 0;
    }

    boolean isNotWhiteNotWord(char character) {
        return (this.getCtypeValue(character) & 0x10) != 0;
    }

    boolean isControlChar(char character) {
        return (this.getCtypeValue(character) & 0x20) != 0;
    }

    boolean isSpace(char character) {
        return (this.getCtypeValue(character) & 0x40) != 0;
    }

    boolean isHexDigit(char character) {
        return (this.getCtypeValue(character) & 0x80) != 0;
    }

    private int getCtypeValue(char character) {
        return this.getCtype().getValue(this.toIndex(character) + 1);
    }

    public char toLower(char character) {
        return this.toChar(this.getLower().getValue(this.toIndex(character)));
    }

    public char toUpper(char character) {
        return this.toChar(this.getUpper().getValue(this.toIndex(character)));
    }

    public int toIndex(char character) {
        int i;
        if (this._indexTable != null && (i = '\u0000' | character) > 0 && i < this._indexTable.length) {
            return this._indexTable[i];
        }
        ByteBuffer buf = this.getCharset().encode(new String(new char[]{character}));
        int index = 0;
        int pos = 1;
        while (buf.hasRemaining()) {
            int current = 255;
            current &= buf.get();
            index |= (current <<= (buf.capacity() - pos++) * 8);
        }
        return index;
    }

    public char toChar(int index) {
        if (this._charTable != null && index >= 0 && index < this._charTable.length) {
            return this._charTable[index];
        }
        byte[] bytes = new byte[4];
        int first = MySqlCharset.toBytes(index, bytes);
        if (first < 0) {
            return '\u0000';
        }
        return this.getCharset().decode(ByteBuffer.wrap(bytes, first, bytes.length - first)).get();
    }

    public char toUnicode(char character) {
        return (char)this.getUnicode().getValue(this.toIndex(character));
    }

    private Charset getCharset() {
        this.initCharset();
        return this._charset;
    }

    private void initCharset() {
        if (this._charset == null && this.getName() != null) {
            this._charset = Charset.forName(this.getName());
            char[] charTable = new char[256];
            int[] indexTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                charTable[i] = this.toChar(i);
                indexTable[i] = this.toIndex((char)i);
            }
            this._charTable = charTable;
            this._indexTable = indexTable;
        }
    }

    public char[] getCharacters() {
        this.initCharset();
        return Arrays.copyOf(this._charTable, this._charTable.length);
    }

    public String toString() {
        return "Charset [_name=" + this._name + ", _collations=" + this._collations + "]";
    }
}

