/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import at.molindo.mysqlcollations.MySqlCollation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.CollationKey;
import java.util.Arrays;

public class MySqlCollationKey
extends CollationKey {
    private final byte[] _weights;
    private final int _hash;

    private MySqlCollationKey(String source, byte[] weights, int hash) {
        super(source);
        this._weights = weights;
        this._hash = hash;
    }

    public MySqlCollationKey(String source, MySqlCollation collation) {
        super(source);
        this._weights = new byte[source.length()];
        int hash = 1;
        int prime = 31;
        for (int i = 0; i < source.length(); ++i) {
            this._weights[i] = collation.getWeight(source.charAt(i));
            hash = 31 * hash + this._weights[i];
        }
        this._hash = hash;
    }

    public int hashCode() {
        return this._hash;
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="performance optimization only")
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MySqlCollationKey)) {
            return false;
        }
        MySqlCollationKey other = (MySqlCollationKey)obj;
        if (other.getSourceString() == this.getSourceString()) {
            return true;
        }
        byte[] oWeights = other._weights;
        if (oWeights.length != this._weights.length) {
            return false;
        }
        for (int i = 0; i < this._weights.length; ++i) {
            byte a = this._weights[i];
            byte b = oWeights[i];
            if (a == b) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CollationKey o) {
        byte[] oWeights = ((MySqlCollationKey)o)._weights;
        int min = this._weights.length <= oWeights.length ? this._weights.length : oWeights.length;
        for (int i = 0; i < min; ++i) {
            byte a = this._weights[i];
            byte b = oWeights[i];
            if (a == b) continue;
            return a - b;
        }
        return this._weights.length - oWeights.length;
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this._weights, this._weights.length);
    }

    public final Object writeReplace() throws ObjectStreamException {
        return new SerializedKey(this.getSourceString(), this._weights, this._hash);
    }

    private static final class SerializedKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _source;
        private final byte[] _weights;
        private final int _hash;

        public SerializedKey(String source, byte[] weights, int hash) {
            this._source = source;
            this._weights = weights;
            this._hash = hash;
        }

        public final Object readResolve() throws ObjectStreamException {
            return new MySqlCollationKey(this._source, this._weights, this._hash);
        }
    }
}

