/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import at.molindo.mysqlcollations.MySqlCollation;
import at.molindo.mysqlcollations.MySqlCollationKey;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Comparator;

public class MySqlCollator
implements Comparator<String>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final MySqlCollation _collation;

    MySqlCollator(MySqlCollation mySqlCollation) {
        this._collation = mySqlCollation;
    }

    @Override
    @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="performance optimization only")
    public int compare(String source, String target) {
        if (source == target) {
            return 0;
        }
        for (int i = 0; i < source.length() && i < target.length(); ++i) {
            byte tWeight;
            byte sWeight = this._collation.getWeight(source.charAt(i));
            if (sWeight == (tWeight = this._collation.getWeight(target.charAt(i)))) continue;
            return sWeight - tWeight;
        }
        return source.length() - target.length();
    }

    @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="performance optimization only")
    public boolean equals(String source, String target) {
        if (source == target) {
            return true;
        }
        if (source.length() != target.length()) {
            return false;
        }
        for (int i = 0; i < source.length() && i < target.length(); ++i) {
            byte tWeight;
            byte sWeight = this._collation.getWeight(source.charAt(i));
            if (sWeight == (tWeight = this._collation.getWeight(target.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public MySqlCollationKey getCollationKey(String source) {
        return new MySqlCollationKey(source, this._collation);
    }

    public String normalize(String string) {
        return this._collation.normalize(string);
    }

    public MySqlCollator clone() {
        try {
            return (MySqlCollator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("cloning Object not supported?", e);
        }
    }
}

