/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify;

import at.molindo.notify.INotifyService;
import at.molindo.notify.channel.IPushChannel;
import at.molindo.notify.confirm.IConfirmationService;
import at.molindo.notify.dao.INotificationDAO;
import at.molindo.notify.dao.IPreferencesDAO;
import at.molindo.notify.dispatch.IPushDispatcher;
import at.molindo.notify.model.Confirmation;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Preferences;
import at.molindo.notify.servlet.INotifyUrlFactory;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class NotifyService
implements INotifyService,
INotifyService.IErrorListener {
    private IPreferencesDAO _preferencesDAO;
    private INotificationDAO _notificationDAO;
    private final Set<INotifyService.IErrorListener> _errorListeners = new CopyOnWriteArraySet<INotifyService.IErrorListener>();
    private final Set<INotifyService.INotificationListner> _notificationListeners = new CopyOnWriteArraySet<INotifyService.INotificationListner>();
    private IPushDispatcher _instantDispatcher;
    private IConfirmationService _confirmationService;
    private INotifyUrlFactory _notifyUrlFactory;
    private Preferences _defaultPreferences = new Preferences();

    @Override
    public IPreferences getPreferences(String userId) {
        return this._preferencesDAO.getPreferences(userId);
    }

    @Override
    public Preferences newPreferences(String userId) {
        Preferences p = this._defaultPreferences.clone();
        p.setUserId(userId);
        p.generateSecret();
        p.getChannelPrefs().putAll(this._instantDispatcher.newDefaultPreferences());
        return p;
    }

    @Override
    public void setPreferences(IPreferences prefs) {
        this._preferencesDAO.savePreferences(prefs);
    }

    @Override
    public void removePreferences(String userId) {
        this._preferencesDAO.removePreferences(userId);
    }

    @Override
    public void notify(Notification notification) {
        this._notificationDAO.save(notification);
        for (INotifyService.INotificationListner l : this._notificationListeners) {
            l.notification(notification);
        }
    }

    @Override
    public void notifyNow(Notification notification) throws INotifyService.NotifyException {
        try {
            this._notificationDAO.save(notification);
            this._instantDispatcher.dispatchNow(notification);
        }
        catch (INotifyService.NotifyException e) {
            this._notificationDAO.delete(notification);
            throw e;
        }
    }

    @Override
    public void confirm(Notification notification) {
        notification.setConfirmation(new Confirmation());
        this.notify(notification);
    }

    @Override
    public void confirmNow(Notification notification) throws INotifyService.NotifyException {
        notification.setConfirmation(new Confirmation());
        this.notifyNow(notification);
    }

    @Override
    public void error(Notification notification, IPushChannel channel, IPushChannel.PushException e) {
        if (this._errorListeners.size() != 0) {
            for (INotifyService.IErrorListener l : this._errorListeners) {
                l.error(notification, channel, e);
            }
        }
    }

    @Override
    public void addErrorListener(INotifyService.IErrorListener listener) {
        this._errorListeners.add(listener);
    }

    @Override
    public void removeErrorListener(INotifyService.IErrorListener listener) {
        this._errorListeners.remove(listener);
    }

    public void setNotificationListeners(Collection<? extends INotifyService.INotificationListner> listeners) {
        if (this._notificationListeners.size() > 0) {
            throw new IllegalStateException("already listeneres registered: " + this._notificationListeners);
        }
        this._notificationListeners.addAll(listeners);
    }

    @Override
    public void addNotificationListener(INotifyService.INotificationListner listner) {
        this._notificationListeners.add(listner);
    }

    @Override
    public void removeNotificationListener(INotifyService.INotificationListner listner) {
        this._notificationListeners.remove(listner);
    }

    @Override
    public void addConfirmationListener(INotifyService.IConfirmationListener listener) {
        this._confirmationService.addConfirmationListener(listener);
    }

    @Override
    public void removeConfirmationListener(INotifyService.IConfirmationListener listener) {
        this._confirmationService.removeConfirmationListener(listener);
    }

    @Override
    public String toPullPath(String channelId, String userId, IParams params) {
        return this._notifyUrlFactory.toPullPath(channelId, userId, params);
    }

    public void setInstantDispatcher(IPushDispatcher instantDispatcher) {
        this._instantDispatcher = instantDispatcher;
    }

    public void setPreferencesDAO(IPreferencesDAO preferencesDAO) {
        this._preferencesDAO = preferencesDAO;
    }

    public void setNotificationDAO(INotificationDAO notificationDAO) {
        this._notificationDAO = notificationDAO;
    }

    public void setDefaultPreferences(Preferences defaultPreferences) {
        if (defaultPreferences == null) {
            throw new NullPointerException("defaultPreferences");
        }
        this._defaultPreferences = defaultPreferences;
    }

    public void setConfirmationService(IConfirmationService confirmationService) {
        this._confirmationService = confirmationService;
    }

    public void setNotifyUrlFactory(INotifyUrlFactory notifyUrlFactory) {
        this._notifyUrlFactory = notifyUrlFactory;
    }
}

