/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.ParamValue;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;

public class Params
implements IParams {
    private Map<String, ParamValue> _params = Maps.newHashMap();

    public Params() {
    }

    public Params(IParams ... params) {
        for (IParams p : params) {
            this.setAll(p);
        }
    }

    public <T> IParams setString(Param<T> param, String value) {
        return this.set(param, param.toObject(value));
    }

    @Override
    public <T> IParams set(Param<T> param, T value) {
        if (value == null) {
            this._params.remove(param.getName());
        } else {
            this._params.put(param.getName(), param.value(value));
        }
        return this;
    }

    @Override
    public <T> T get(Param<T> param) {
        ParamValue v = this._params.get(param.getName());
        if (v == null || v.getValue() == null) {
            return null;
        }
        if (param.getType().isAssignableFrom(v.getValue().getClass())) {
            return param.getType().cast(v.getValue());
        }
        Param<?> valueParam = v.getType().p(param.getName());
        String valueStr = valueParam.toString(v.getValue());
        return param.toObject(valueStr);
    }

    @Override
    public boolean isSet(Param<?> param) {
        return this._params.get(param.getName()) != null;
    }

    @Override
    public boolean containsAll(Param<?> ... params) {
        for (Param<?> p : params) {
            if (this._params.containsKey(p.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public IParams setAll(IParams params) {
        IParams.Util.setAll(this, params);
        return this;
    }

    @Override
    public Map<String, Object> newMap() {
        return IParams.Util.newMap(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._params == null ? 0 : this._params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Params)) {
            return false;
        }
        Params other = (Params)obj;
        return !(this._params == null ? other._params != null : !this._params.equals(other._params));
    }

    public String toString() {
        return "Params [params=" + this._params + "]";
    }

    protected Params clone() {
        try {
            Params p = (Params)super.clone();
            p._params = Maps.newHashMap(this._params);
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("can't clone object?", e);
        }
    }

    protected Map<String, ParamValue> getValues() {
        return this._params;
    }

    protected void setValues(Map<String, ParamValue> params) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        this._params = params;
    }

    @Override
    public Iterator<ParamValue> iterator() {
        return this._params.values().iterator();
    }
}

