/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.render.velocity;

import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Template;
import at.molindo.notify.render.IRenderService;
import at.molindo.notify.render.ITemplateRenderer;
import at.molindo.notify.util.VelocityUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.springframework.beans.factory.InitializingBean;

public class VelocityTemplateRenderer
implements ITemplateRenderer,
InitializingBean {
    private final Cache<Template.Key, Template> _templateCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).concurrencyLevel(4).build();
    private RuntimeServices _runtime = new RuntimeInstance();

    public final void afterPropertiesSet() throws Exception {
        this.init();
    }

    public VelocityTemplateRenderer init() {
        this._runtime = VelocityUtils.newRuntime();
        return this;
    }

    @Override
    public String render(at.molindo.notify.model.Template template, IParams params) throws IRenderService.RenderException {
        return VelocityUtils.merge(this.getVelocityTemplate(template), params);
    }

    private Template getVelocityTemplate(at.molindo.notify.model.Template template) throws IRenderService.RenderException {
        Template.Key key = template.key();
        Template vt = (Template)this._templateCache.getIfPresent((Object)key);
        if (vt == null) {
            vt = this.toVelocityTemplate(template);
            this._templateCache.put((Object)key, (Object)vt);
        }
        return vt;
    }

    private Template toVelocityTemplate(at.molindo.notify.model.Template template) throws IRenderService.RenderException {
        return VelocityUtils.newTemplate(this._runtime, template.getContent(), template.getKey() + "." + (Object)((Object)template.getVersion()));
    }
}

