/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.feed;

import at.molindo.notify.channel.IPullChannel;
import at.molindo.notify.channel.feed.AbstractPullChannel;
import at.molindo.notify.channel.feed.FeedUtils;
import at.molindo.notify.model.IChannelPreferences;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.Message;
import at.molindo.notify.model.Params;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.data.Hash;
import com.google.common.collect.Lists;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeedChannel
extends AbstractPullChannel {
    private static final Logger log = LoggerFactory.getLogger(AbstractFeedChannel.class);
    private String _authorName;
    private String _feedTitle;

    @Override
    protected String pull(List<Message> messages, Date lastModified, IChannelPreferences cPrefs, IPreferences prefs) throws IPullChannel.PullException {
        try {
            return FeedUtils.toFeedXml(this.toFeed(messages, lastModified, prefs, cPrefs));
        }
        catch (FeedException e) {
            throw new IPullChannel.PullException("failed to serialize feed", e);
        }
        catch (IRenderService.RenderException e) {
            log.info("failed to render feed", (Throwable)e);
            return null;
        }
    }

    public WireFeed toFeed(List<Message> messages, Date lastModified, IPreferences prefs, IChannelPreferences cPrefs) throws IRenderService.RenderException {
        Feed f = new Feed("atom_1.0");
        f.setTitle(this._feedTitle);
        f.setUpdated(lastModified == null ? new Date() : lastModified);
        Person author = new Person();
        author.setName(this._authorName);
        f.setAuthors(Arrays.asList(author));
        ArrayList entries = Lists.newArrayList();
        for (Message msg : messages) {
            Entry e = new Entry();
            Content c = new Content();
            c.setType("text/html");
            c.setValue(msg.getHtml());
            e.setId(Hash.md5((String)msg.getSubject()).toHex());
            e.setUpdated(new Date());
            e.setTitle(msg.getSubject());
            e.setContents(Arrays.asList(c));
            entries.add(e);
        }
        f.setEntries((List)entries);
        return f;
    }

    @Override
    public boolean isConfigured(Params params) {
        return super.isConfigured(params);
    }

    public String getAuthorName() {
        return this._authorName;
    }

    public void setAuthorName(String authorName) {
        this._authorName = authorName;
    }

    public String getFeedTitle() {
        return this._feedTitle;
    }

    public void setFeedTitle(String feedTitle) {
        this._feedTitle = feedTitle;
    }
}

