/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.mail.AbstractMailClient;
import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.notify.channel.mail.MailUtils;
import at.molindo.utils.collections.CollectionUtils;
import at.molindo.utils.data.ExceptionUtils;
import at.molindo.utils.net.DnsUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPSendFailedException;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;

public class DirectMailClient
extends AbstractMailClient
implements InitializingBean {
    private static final int DEFAULT_CACHE_CONCURRENCY = 4;
    private static final long DEFAULT_CACHE_EXPIRATION_MIN = 10L;
    private static final String CONNECTION_TIMEOUT_MS = "60000";
    private static final String READ_TIMEOUT_MS = "60000";
    private static final int MAILBOX_UNAVAILABLE = 550;
    private static final int MAILBOX_NOT_LOCAL = 551;
    private static final int MAILBOX_NAME_NOT_ALLOWED = 553;
    private static final int TRANSACTION_FAILED = 554;
    private static final Set<Integer> PERMANENT_ERROR_CODES = Collections.unmodifiableSet(CollectionUtils.set((Object[])new Integer[]{550, 551, 553, 554}));
    private LoadingCache<String, Session> _sessionCache;
    private int _cacheConcurrency = 4;
    private long _cacheExpirationMin = 10L;
    private String _localAddress;
    private String _socksProxyHost;
    private String _socksProxyPort;
    private Boolean _proxySet;
    private String _localHost;
    private boolean _startTLSEnabled = false;

    @Override
    public DirectMailClient init() throws IMailClient.MailException {
        super.init();
        this._sessionCache = CacheBuilder.newBuilder().concurrencyLevel(this._cacheConcurrency).expireAfterAccess(this._cacheExpirationMin, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Session>(){

            public Session load(String domain) throws IMailClient.MailException {
                return DirectMailClient.this.createSmtpSession(domain);
            }
        });
        return this;
    }

    @Override
    protected Session getSmtpSession(String recipient) throws IMailClient.MailException {
        try {
            return (Session)this._sessionCache.get((Object)MailUtils.domainFromAddress(recipient));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IMailClient.MailException) {
                throw (IMailClient.MailException)e.getCause();
            }
            throw new RuntimeException("unexpected exception while getting SMTP session for " + recipient, e);
        }
    }

    protected Session createSmtpSession(String domain) throws IMailClient.MailException {
        try {
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", DnsUtils.lookupMailHosts((String)domain)[0]);
            props.setProperty("mail.smtp.port", "25");
            props.setProperty("mail.smtp.auth", "false");
            props.setProperty("mail.smtp.starttls.enable", Boolean.toString(this.getStartTLSEnabled()));
            if (Boolean.TRUE.equals(this.getProxySet())) {
                props.setProperty("proxySet", "true");
                props.setProperty("socksProxyHost", this.getSocksProxyHost());
                props.setProperty("socksProxyPort", this.getSocksProxyPort());
            }
            if (this.getLocalHost() != null) {
                props.setProperty("mail.smtp.localhost", this.getLocalHost());
            }
            if (this.getLocalAddress() != null) {
                props.setProperty("mail.smtp.localaddress", this.getLocalAddress());
            }
            props.setProperty("mail.smtp.connectiontimeout", "60000");
            props.setProperty("mail.smtp.timeout", "60000");
            return Session.getInstance((Properties)props);
        }
        catch (NamingException e) {
            throw new IMailClient.MailException("can't lookup mail host: " + domain, e, true);
        }
    }

    @Override
    protected String toErrorMessage(MessagingException e) {
        if (e instanceof SendFailedException) {
            if (e.getNextException() instanceof SMTPSendFailedException) {
                SMTPSendFailedException se = (SMTPSendFailedException)e.getNextException();
                return se.getCommand() + " failed " + " with " + se.getReturnCode() + " (" + e.getMessage() + ")";
            }
            if (e.getNextException() instanceof SMTPAddressFailedException) {
                SMTPAddressFailedException se = (SMTPAddressFailedException)e.getNextException();
                return se.getCommand() + " failed " + " with " + se.getReturnCode() + " (" + e.getMessage() + ")";
            }
            StringBuilder buf = new StringBuilder();
            Address[] addresses = ((SendFailedException)e).getInvalidAddresses();
            if (addresses != null) {
                for (Address a : addresses) {
                    buf.append(a).append(" ");
                }
            }
            return "invalied address(es): " + buf + "(" + ExceptionUtils.getAllMessages((Throwable)e) + ")";
        }
        return super.toErrorMessage(e);
    }

    @Override
    protected boolean isTemporary(MessagingException e) {
        if (e instanceof SendFailedException) {
            if (e.getNextException() instanceof SMTPSendFailedException) {
                SMTPSendFailedException se = (SMTPSendFailedException)e.getNextException();
                int rc = se.getReturnCode();
                return !PERMANENT_ERROR_CODES.contains(rc);
            }
            if (e.getNextException() instanceof SMTPAddressFailedException) {
                SMTPAddressFailedException se = (SMTPAddressFailedException)e.getNextException();
                int rc = se.getReturnCode();
                return !PERMANENT_ERROR_CODES.contains(rc);
            }
            return true;
        }
        return true;
    }

    public int getCacheConcurrency() {
        return this._cacheConcurrency;
    }

    public void setCacheConcurrency(int cacheConcurrency) {
        this._cacheConcurrency = cacheConcurrency;
    }

    public long getCacheExpirationMin() {
        return this._cacheExpirationMin;
    }

    public void setCacheExpirationMin(long cacheExpirationMin) {
        this._cacheExpirationMin = cacheExpirationMin;
    }

    public void setLocalAddress(String localAddress) {
        this._localAddress = localAddress;
    }

    public void setLocalHost(String localHost) {
        this._localHost = localHost;
    }

    public String getLocalAddress() {
        return this._localAddress;
    }

    public String getLocalHost() {
        return this._localHost;
    }

    public void setStartTLSEnabled(boolean startTLSEnabled) {
        this._startTLSEnabled = startTLSEnabled;
    }

    public boolean getStartTLSEnabled() {
        return this._startTLSEnabled;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this._socksProxyHost = socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this._socksProxyPort = socksProxyPort;
    }

    public void setProxySet(Boolean proxySet) {
        this._proxySet = proxySet;
    }

    private String getSocksProxyHost() {
        return this._socksProxyHost;
    }

    private String getSocksProxyPort() {
        return this._socksProxyPort;
    }

    private Boolean getProxySet() {
        return this._proxySet;
    }
}

