/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.dao.file;

import at.molindo.notify.dao.ITemplateDAO;
import at.molindo.notify.model.Template;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.collections.ArrayUtils;
import at.molindo.utils.io.Compression;
import at.molindo.utils.io.FileUtils;
import at.molindo.utils.io.StreamUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTemplateDAO
implements ITemplateDAO {
    private static final Logger log = LoggerFactory.getLogger(FileTemplateDAO.class);
    private static final Pattern PATTERN;
    private File _baseDir;

    @Override
    public List<Template> findTemplates(String key) {
        ArrayList templates = Lists.newArrayList();
        File keyDir = new File(this._baseDir, key);
        if (!keyDir.isDirectory()) {
            return templates;
        }
        for (File template : ArrayUtils.iterable((Object[])keyDir.listFiles())) {
            Matcher m = PATTERN.matcher(template.getName());
            if (!m.matches()) continue;
            try {
                templates.add(new Template().setKey(key).setVersion(IRenderService.Version.valueOf(m.group(1).toUpperCase())).setLocale(m.group(2) == null ? null : new Locale(m.group(2))).setType(IRenderService.Type.valueOf(m.group(3).toUpperCase())).setLastModified(new Date(template.lastModified())).setContent(StreamUtils.string((InputStream)FileUtils.in((File)template, (Compression)Compression.NONE))));
            }
            catch (IOException e) {
                log.warn("failed to read template from " + template, (Throwable)e);
            }
        }
        return templates;
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public void setBaseDir(File baseDir) {
        if (baseDir != null && !baseDir.isDirectory()) {
            throw new IllegalArgumentException("baseDir not a directory: " + baseDir);
        }
        this._baseDir = baseDir;
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.append("^(");
        for (IRenderService.Version version : IRenderService.Version.values()) {
            buf.append(version.name().toLowerCase()).append("|");
        }
        buf.setCharAt(buf.length() - 1, ')');
        buf.append("\\.");
        buf.append("([a-z]{2})?");
        buf.append("\\.");
        buf.append("(");
        for (Enum enum_ : IRenderService.Type.values()) {
            buf.append(enum_.name().toLowerCase()).append("|");
        }
        buf.setCharAt(buf.length() - 1, ')');
        buf.append("$");
        String pattern = buf.toString();
        log.debug("file name pattern: " + pattern);
        PATTERN = Pattern.compile(pattern);
    }
}

