/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.dispatch;

import at.molindo.notify.INotifyService;
import at.molindo.notify.channel.IPushChannel;
import at.molindo.notify.dao.INotificationDAO;
import at.molindo.notify.dao.IPreferencesDAO;
import at.molindo.notify.dispatch.IDispatchService;
import at.molindo.notify.dispatch.IPushDispatcher;
import at.molindo.notify.model.Dispatch;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.IPushChannelPreferences;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Preferences;
import at.molindo.notify.model.PushChannelPreferences;
import at.molindo.notify.model.PushState;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.data.ExceptionUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractPushDispatcher
implements IPushDispatcher,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractPushDispatcher.class);
    private static final int DEFAULT_MAX_ERROR = 3;
    private Set<IPushChannel> _pushChannels = new CopyOnWriteArraySet<IPushChannel>();
    private INotifyService.IErrorListener _errorListener;
    private IDispatchService _dispatchService;
    private IPreferencesDAO _preferencesDAO;
    private INotificationDAO _notificationDAO;
    private int _maxErrorCount = 3;

    public void afterPropertiesSet() {
        if (this._pushChannels.size() == 0) {
            throw new IllegalStateException("no push channels configured");
        }
        if (this._dispatchService == null) {
            throw new IllegalStateException("no dispatchService configured");
        }
        if (this._notificationDAO == null) {
            throw new IllegalStateException("no notificationDAO configured");
        }
    }

    @Nonnull
    private PushResultMessage push(@Nonnull Notification notification, boolean ignoreFrequency) {
        final String unknownChannel = notification.getParams().get(INotifyService.NOTIFY_UNKNOWN);
        IPreferences prefs = unknownChannel != null ? new Preferences().setUserId(notification.getUserId()) : this._preferencesDAO.getPreferences(notification.getUserId());
        if (prefs == null) {
            log.warn("can't push to unknown user " + notification.getUserId());
            return PushResultMessage.persistent("unknown user " + notification.getUserId());
        }
        HashSet successChannels = Sets.newHashSet();
        HashMap temporaryChannels = Maps.newHashMap();
        HashMap persistentChannels = Maps.newHashMap();
        Iterable channels = Iterables.filter(this._pushChannels, (Predicate)new Predicate<IPushChannel>(){

            public boolean apply(IPushChannel channel) {
                return unknownChannel == null || channel.getId().equals(unknownChannel);
            }
        });
        for (IPushChannel channel : channels) {
            try {
                this.pushChannel(channel, prefs, notification, ignoreFrequency);
                successChannels.add(channel.getId());
            }
            catch (IPushChannel.PushException e) {
                if (e.isTemporaryError()) {
                    temporaryChannels.put(channel.getId(), e.getMessage());
                } else {
                    persistentChannels.put(channel.getId(), e.getMessage());
                }
                if (this._errorListener != null) {
                    this._errorListener.error(notification, channel, e);
                    continue;
                }
                log.info("failed to deliver notification " + notification + " on channel " + channel.getId() + ": " + ExceptionUtils.getAllMessages((Throwable)e));
            }
            catch (IRenderService.RenderException e) {
                log.error("failed to render notification " + notification, (Throwable)e);
                temporaryChannels.put(channel.getId(), ExceptionUtils.getAllMessages((Throwable)e));
            }
        }
        if (successChannels.size() > 0) {
            return PushResultMessage.success("channels: " + successChannels);
        }
        if (temporaryChannels.size() > 0) {
            return PushResultMessage.temporary("temporary error, channels: " + temporaryChannels);
        }
        if (persistentChannels.size() > 0) {
            return PushResultMessage.persistent("persistent error, channels: " + persistentChannels);
        }
        return PushResultMessage.temporary("no allowed channels available");
    }

    private void pushChannel(IPushChannel channel, IPreferences prefs, Notification notification, boolean ignoreFrequency) throws IPushChannel.PushException, IRenderService.RenderException {
        IPushChannelPreferences cPrefs = prefs.getChannelPrefs().get(channel.getId());
        if (cPrefs == null && (cPrefs = channel.newDefaultPreferences()) == null) {
            throw new IPushChannel.PushException("channel not configured for user", false);
        }
        if (!channel.getNotificationTypes().contains((Object)notification.getType())) {
            throw new IPushChannel.PushException("channel not applicable for type " + (Object)((Object)notification.getType()), false);
        }
        Dispatch dispatch = this._dispatchService.create(notification, prefs, cPrefs);
        if (!channel.isConfigured(dispatch.getParams())) {
            throw new IPushChannel.PushException("channel not configured for user", false);
        }
        if (!ignoreFrequency && !PushChannelPreferences.Frequency.INSTANT.equals((Object)cPrefs.getFrequency())) {
            throw new IPushChannel.PushException("channel not configured for this frequency", true);
        }
        channel.push(dispatch);
    }

    @Override
    public void dispatchNow(Notification notification) throws INotifyService.NotifyException {
        this.dispatch(notification, true);
    }

    protected void dispatch(@Nonnull Notification notification) {
        try {
            this.dispatch(notification, false);
        }
        catch (INotifyService.NotifyException e) {
            throw new INotifyService.NotifyRuntimeException("unexpected NotifyException", e);
        }
    }

    private void dispatch(Notification notification, boolean ignoreFrequency) throws INotifyService.NotifyException {
        PushResultMessage rm = this.push(notification, ignoreFrequency);
        if (ignoreFrequency && rm.getResult() != PushResult.SUCCESS) {
            throw new INotifyService.NotifyException("failed to dispatch now: " + notification + " (" + rm.getMessage() + ")");
        }
        this.recordPushAttempt(notification, rm);
    }

    private void recordPushAttempt(Notification notification, @Nonnull PushResultMessage rm) {
        if (rm.getResult() == PushResult.SUCCESS) {
            notification.setPushState(PushState.PUSHED);
            notification.setPushDate(new Date());
            notification.setPushErrorMessage(rm.getMessage());
        } else {
            int errorCount = notification.recordPushError(rm.getMessage());
            if (errorCount > this._maxErrorCount || rm.getResult() == PushResult.PERSISTENT_ERROR) {
                notification.setPushState(PushState.UNDELIVERABLE);
                notification.setPushDate(new Date());
            } else {
                notification.setPushState(PushState.QUEUED);
                notification.setPushDate(new Date(System.currentTimeMillis() + this.waitAfter(errorCount)));
            }
        }
        this._notificationDAO.update(notification);
    }

    private long waitAfter(int errorCount) {
        switch (errorCount) {
            case 0: {
                return 0L;
            }
            case 1: {
                return 60000L;
            }
            case 2: {
                return 900000L;
            }
            case 3: {
                return 0x6DDD00L;
            }
            case 4: {
                return 86400000L;
            }
        }
        return 259200000L;
    }

    @Override
    public void setErrorListener(INotifyService.IErrorListener errorListener) {
        this._errorListener = errorListener;
    }

    @Override
    public Map<String, IPushChannelPreferences> newDefaultPreferences() {
        HashMap map = Maps.newHashMap();
        for (IPushChannel channel : this._pushChannels) {
            IPushChannelPreferences cPrefs = channel.newDefaultPreferences();
            if (cPrefs == null) continue;
            map.put(channel.getId(), cPrefs);
        }
        return map;
    }

    public void setDispatchService(IDispatchService dispatchService) {
        this._dispatchService = dispatchService;
    }

    public void setPreferencesDAO(IPreferencesDAO preferencesDAO) {
        this._preferencesDAO = preferencesDAO;
    }

    public void setPushChannels(Set<IPushChannel> pushChannels) {
        this._pushChannels = pushChannels;
    }

    public void setMaxErrorCount(int maxErrorCount) {
        this._maxErrorCount = maxErrorCount;
    }

    public void setNotificationDAO(INotificationDAO notificationDAO) {
        this._notificationDAO = notificationDAO;
    }

    protected Set<IPushChannel> getPushChannels() {
        return this._pushChannels;
    }

    protected INotifyService.IErrorListener getErrorListener() {
        return this._errorListener;
    }

    protected IDispatchService getDispatchService() {
        return this._dispatchService;
    }

    protected IPreferencesDAO getPreferencesDAO() {
        return this._preferencesDAO;
    }

    protected INotificationDAO getNotificationDAO() {
        return this._notificationDAO;
    }

    protected int getMaxErrorCount() {
        return this._maxErrorCount;
    }

    protected static class PushResultMessage {
        private final String _message;
        private final PushResult _result;

        private static PushResultMessage success(String message) {
            return new PushResultMessage(message, PushResult.SUCCESS);
        }

        private static PushResultMessage persistent(String message) {
            return new PushResultMessage(message, PushResult.PERSISTENT_ERROR);
        }

        private static PushResultMessage temporary(String message) {
            return new PushResultMessage(message, PushResult.TEMPORARY_ERROR);
        }

        private PushResultMessage(String message, PushResult result) {
            if (result == null) {
                throw new NullPointerException("result");
            }
            this._message = message;
            this._result = result;
        }

        public String getMessage() {
            return this._message;
        }

        public PushResult getResult() {
            return this._result;
        }

        public String toString() {
            return (Object)((Object)this._result) + " (" + this._message + ")";
        }
    }

    protected static enum PushResult {
        SUCCESS,
        TEMPORARY_ERROR,
        PERSISTENT_ERROR;

    }
}

