/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.model.IParams;
import at.molindo.notify.model.ParamType;
import at.molindo.notify.model.ParamValue;
import at.molindo.utils.data.HexUtils;
import at.molindo.utils.data.SerializationUtils;
import at.molindo.utils.data.StringUtils;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;

public abstract class Param<T> {
    private String _name;
    private Class<T> _type;

    public static Param<String> pString(String name) {
        return new Param<String>(name, String.class){

            @Override
            protected String string(String object) {
                return object;
            }

            @Override
            protected String object(String string) {
                return string;
            }

            @Override
            protected ParamType type() {
                return ParamType.STRING;
            }
        };
    }

    public static Param<Integer> pInteger(String name) {
        return new Param<Integer>(name, Integer.class){

            @Override
            protected Integer object(String string) {
                return Integer.parseInt(string);
            }

            @Override
            protected ParamType type() {
                return ParamType.INTEGER;
            }
        };
    }

    public static Param<Long> pLong(String name) {
        return new Param<Long>(name, Long.class){

            @Override
            protected Long object(String string) {
                return Long.parseLong(string);
            }

            @Override
            protected ParamType type() {
                return ParamType.LONG;
            }
        };
    }

    public static Param<Double> pDouble(String name) {
        return new Param<Double>(name, Double.class){

            @Override
            protected Double object(String string) {
                return Double.parseDouble(string);
            }

            @Override
            protected ParamType type() {
                return ParamType.DOUBLE;
            }
        };
    }

    public static Param<Float> pFloat(String name) {
        return new Param<Float>(name, Float.class){

            @Override
            protected Float object(String string) {
                return Float.valueOf(Float.parseFloat(string));
            }

            @Override
            protected ParamType type() {
                return ParamType.FLOAT;
            }
        };
    }

    public static Param<Boolean> pBoolean(String name) {
        return new Param<Boolean>(name, Boolean.class){

            @Override
            protected Boolean object(String string) {
                return Boolean.parseBoolean(string);
            }

            @Override
            protected ParamType type() {
                return ParamType.BOOLEAN;
            }
        };
    }

    public static Param<Character> pCharacter(String name) {
        return new Param<Character>(name, Character.class){

            @Override
            protected Character object(String string) {
                return Character.valueOf(string.charAt(0));
            }

            @Override
            protected ParamType type() {
                return ParamType.CHARACTER;
            }
        };
    }

    public static Param<URL> pURL(String name) {
        return new Param<URL>(name, URL.class){

            @Override
            protected URL object(String string) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected ParamType type() {
                return ParamType.URL;
            }
        };
    }

    public static Param<Object> pSerializable(String name) {
        return new Param<Object>(name, Object.class){

            @Override
            protected Object object(String string) {
                try {
                    return SerializationUtils.deserialize((byte[])HexUtils.bytes((String)string));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected String string(Object object) {
                try {
                    return HexUtils.string((byte[])SerializationUtils.serialize((Object)object));
                }
                catch (NotSerializableException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected ParamType type() {
                return ParamType.SERIALIZABLE;
            }
        };
    }

    public static Param<Object> pObject(String name) {
        return new Param<Object>(name, Object.class){

            @Override
            protected String string(Object object) {
                throw new RuntimeException("can't convert from unknown type to string " + object);
            }

            @Override
            protected Object object(String string) {
                throw new RuntimeException("can't convert to unknown type from " + string);
            }

            @Override
            protected ParamType type() {
                return ParamType.OBJECT;
            }
        };
    }

    static Param<?> p(Class<?> cls, String name) {
        if (String.class.isAssignableFrom(cls)) {
            return Param.pString(name);
        }
        if (Integer.class.isAssignableFrom(cls) || Integer.TYPE.equals(cls)) {
            return Param.pInteger(name);
        }
        if (Long.class.isAssignableFrom(cls) || Long.TYPE.equals(cls)) {
            return Param.pLong(name);
        }
        if (Double.class.isAssignableFrom(cls) || Double.TYPE.equals(cls)) {
            return Param.pDouble(name);
        }
        if (Float.class.isAssignableFrom(cls) || Float.TYPE.equals(cls)) {
            return Param.pFloat(name);
        }
        if (Boolean.class.isAssignableFrom(cls) || Boolean.TYPE.equals(cls)) {
            return Param.pBoolean(name);
        }
        if (Character.class.isAssignableFrom(cls) || Character.TYPE.equals(cls)) {
            return Param.pCharacter(name);
        }
        if (URL.class.isAssignableFrom(cls)) {
            return Param.pURL(name);
        }
        if (Serializable.class.isAssignableFrom(cls)) {
            return Param.pSerializable(name);
        }
        return Param.pObject(name);
    }

    private Param() {
    }

    private Param(String name, Class<T> cls) {
        this();
        this.setName(name);
        this.setType(cls);
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (StringUtils.empty((String)name)) {
            throw new IllegalArgumentException("name must not be empty");
        }
        this._name = name;
    }

    public Class<T> getType() {
        return this._type;
    }

    protected void setType(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this._type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Param)) {
            return false;
        }
        Param other = (Param)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().getName().equals(other.getType().getName()));
    }

    public String toString() {
        return "Param [name=" + this._name + ", type=" + this._type == null ? null : this._type.getSimpleName() + "]";
    }

    public ParamValue value(T value) {
        return new ParamValue(this, value);
    }

    public final String toString(Object o) {
        if (o == null) {
            return null;
        }
        return this.string(this.getType().cast(o));
    }

    public final T toObject(String string) {
        if (string == null) {
            return null;
        }
        return this.object(string);
    }

    protected String string(@Nonnull T object) {
        return object.toString();
    }

    @Nonnull
    protected abstract T object(@Nonnull String var1);

    protected abstract ParamType type();

    void set(@Nonnull IParams target, Object object) {
        target.set(this, this._type.cast(object));
    }

    ParamValue paramValue(Object object) {
        return new ParamValue(this, this._type.cast(object));
    }
}

