/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.render.IRenderService;
import java.util.Date;
import java.util.Locale;

public class Template
implements Cloneable {
    private String _key;
    private IRenderService.Type _type = IRenderService.Type.HTML;
    private IRenderService.Version _version = IRenderService.Version.LONG;
    private Date _lastModified;
    private Locale _locale;
    private String _content;

    public Template() {
    }

    public Template(String key, IRenderService.Type type, IRenderService.Version version, Locale locale, String content) {
        this.setKey(key);
        this.setType(type);
        this.setVersion(version);
        this.setLocale(locale);
        this.setContent(content);
        this.setLastModified(new Date());
    }

    public String getKey() {
        return this._key;
    }

    public Template setKey(String key) {
        this._key = key;
        return this;
    }

    public IRenderService.Type getType() {
        return this._type;
    }

    public Template setType(IRenderService.Type type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this._type = type;
        return this;
    }

    public IRenderService.Version getVersion() {
        return this._version;
    }

    public Template setVersion(IRenderService.Version version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this._version = version;
        return this;
    }

    public String getContent() {
        return this._content;
    }

    public Template setContent(String content) {
        this._content = content;
        return this;
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public Template setLastModified(Date lastModified) {
        this._lastModified = lastModified;
        return this;
    }

    public Key key() {
        return this.getKey() == null || this.getVersion() == null ? null : new Key(this.getKey(), this.getVersion());
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Template setLocale(Locale locale) {
        this._locale = locale;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getKey() == null ? 0 : this.getKey().hashCode());
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        result = 31 * result + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getLastModified() == null ? other.getLastModified() != null : !this.getLastModified().equals(other.getLastModified())) {
            return false;
        }
        if (this.getLocale() == null ? other.getLocale() != null : !this.getLocale().equals(other.getLocale())) {
            return false;
        }
        return !(this.getContent() == null ? other.getContent() != null : !this.getContent().equals(other.getContent()));
    }

    public String toString() {
        return "Template [_key=" + this._key + ", _version=" + (Object)((Object)this._version) + ", _lastModified=" + this._lastModified + "]";
    }

    public Template clone() {
        try {
            Template t = (Template)super.clone();
            if (this._lastModified != null) {
                t._lastModified = new Date(this._lastModified.getTime());
            }
            if (this._locale != null) {
                t._locale = (Locale)this._locale.clone();
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone object not supported?", e);
        }
    }

    public static final class Key {
        private final String _key;
        private final IRenderService.Version _version;

        private Key(String key, IRenderService.Version version) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (version == null) {
                throw new NullPointerException("version");
            }
            this._key = key;
            this._version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._key.hashCode();
            result = 31 * result + this._version.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (!this._key.equals(other._key)) {
                return false;
            }
            return this._version == other._version;
        }
    }
}

