/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.render;

import at.molindo.notify.dao.ITemplateDAO;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Message;
import at.molindo.notify.model.Template;
import at.molindo.notify.render.IRenderService;
import at.molindo.notify.render.ITemplateRenderer;
import at.molindo.notify.util.NotifyUtils;
import org.springframework.beans.factory.InitializingBean;

public class TemplateRenderService
implements IRenderService,
InitializingBean {
    private ITemplateDAO _templateDAO;
    private ITemplateRenderer _renderer;

    public void afterPropertiesSet() throws Exception {
        if (this._renderer == null) {
            throw new Exception("renderer not configured");
        }
        if (this._templateDAO == null) {
            throw new Exception("templateDAO not configured");
        }
    }

    @Override
    public Message render(String key, IRenderService.Version version, IParams params) throws IRenderService.RenderException {
        Template template = NotifyUtils.choose(this._templateDAO.findTemplates(key), null, version);
        if (template == null) {
            throw new IRenderService.RenderException("no template available for '" + key + "' (" + (Object)((Object)version) + ")");
        }
        return Message.parse(this._renderer.render(template, params), template.getType());
    }

    ITemplateDAO getTemplateDAO() {
        return this._templateDAO;
    }

    public void setTemplateDAO(ITemplateDAO templateDAO) {
        this._templateDAO = templateDAO;
    }

    ITemplateRenderer getRenderer() {
        return this._renderer;
    }

    public void setRenderer(ITemplateRenderer renderer) {
        this._renderer = renderer;
    }
}

