/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.util;

import at.molindo.notify.model.Template;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.collections.IteratorUtils;
import at.molindo.utils.data.StringUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class NotifyUtils {
    private static final Comparator<Template> TEMPLATE_COMPARATOR = new Comparator<Template>(){

        @Override
        public int compare(Template t1, Template t2) {
            if (t1 == t2) {
                return 0;
            }
            int val = t1.getType().compareTo(t2.getType());
            if (val != 0) {
                return val;
            }
            return t1.getVersion().compareTo(t2.getVersion());
        }
    };

    private NotifyUtils() {
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    public static String html2text(String html) {
        Renderer renderer = new Renderer((Segment)new Source((CharSequence)html)){
            {
                this.setIncludeHyperlinkURLs(true);
            }

            public String renderHyperlinkURL(StartTag startTag) {
                String href = startTag.getAttributeValue("href");
                if (href == null || href.equals("#") || href.startsWith("javascript:")) {
                    return null;
                }
                return '<' + href + '>';
            }
        };
        String text = renderer.toString();
        String newLine = renderer.getNewLine();
        while (text != (text = StringUtils.stripLeading((String)text, (String)newLine))) {
        }
        while (text != (text = StringUtils.stripTrailing((String)text, (String)newLine))) {
        }
        return text;
    }

    public static String text2html(String text) {
        return text.replaceAll("\n", "<br />");
    }

    public static Template choose(@Nonnull List<Template> templates, final IRenderService.Type type, final IRenderService.Version version) {
        ArrayList filtered = IteratorUtils.list((Iterator)Iterators.filter(templates.iterator(), (Predicate)new Predicate<Template>(){

            public boolean apply(Template input) {
                if (type != null && type != input.getType()) {
                    return false;
                }
                return version == null || version == input.getVersion();
            }
        }), (int)templates.size());
        switch (filtered.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Template)filtered.get(0);
            }
        }
        Collections.sort(filtered, TEMPLATE_COMPARATOR);
        return (Template)filtered.get(0);
    }
}

