/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.support;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.springframework.context.ApplicationContext;
import org.springframework.data.custom.repository.support.CustomRepositoryQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class CustomQueryLookupStrategy
implements QueryLookupStrategy {
    @NonNull
    private final ApplicationContext applicationContext;

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        return new CustomRepositoryQuery(method, metadata, factory, this.applicationContext);
    }

    @ConstructorProperties(value={"applicationContext"})
    public CustomQueryLookupStrategy(@NonNull ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext");
        }
        this.applicationContext = applicationContext;
    }
}

