/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.thirdparty.org.apache.wicket.util.time;

import at.molindo.thirdparty.org.apache.wicket.util.time.AbstractTime;
import at.molindo.thirdparty.org.apache.wicket.util.time.Duration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class Time
extends AbstractTime {
    private static final long serialVersionUID = 1L;
    public static final Time START_OF_UNIX_TIME = Time.milliseconds(0L);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd-h.mma");

    public static Time milliseconds(long time) {
        return new Time(time);
    }

    public static Time now() {
        return new Time(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time parseDate(Calendar calendar, String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateFormat.setCalendar(calendar);
                return Time.valueOf(dateFormat.parse(string));
            }
        }
    }

    public static Time parseDate(String string) throws ParseException {
        return Time.parseDate(localtime, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time valueOf(Calendar calendar, String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateTimeFormat.setCalendar(calendar);
                return Time.valueOf(dateTimeFormat.parse(string));
            }
        }
    }

    public static Time valueOf(Date date) {
        return new Time(date.getTime());
    }

    public static Time valueOf(long time) {
        return new Time(time);
    }

    public static Time valueOf(String string) throws ParseException {
        return Time.valueOf(localtime, string);
    }

    public static Time valueOf(String string, String pattern) throws ParseException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(pattern);
        dateTimeFormat.setCalendar(localtime);
        return Time.valueOf(dateTimeFormat.parse(string));
    }

    private Time(long time) {
        super(time);
    }

    public Time add(Duration duration) {
        return Time.milliseconds(this.getMilliseconds() + duration.getMilliseconds());
    }

    public Duration elapsedSince() {
        Time now = Time.now();
        if (this.greaterThan(now)) {
            throw new IllegalStateException("This time is in the future");
        }
        return now.subtract(this);
    }

    public Duration fromNow() {
        return this.subtract(Time.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(Calendar calendar, int field) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(this.getMilliseconds());
            return calendar.get(field);
        }
    }

    public int get(int field) {
        return this.get(localtime, field);
    }

    public int getDayOfMonth() {
        return this.getDayOfMonth(localtime);
    }

    public int getDayOfMonth(Calendar calendar) {
        return this.get(calendar, 5);
    }

    public int getHour() {
        return this.getHour(localtime);
    }

    public int getHour(Calendar calendar) {
        return this.get(calendar, 10);
    }

    public int getMinute() {
        return this.getMinute(localtime);
    }

    public int getMinute(Calendar calendar) {
        return this.get(calendar, 12);
    }

    public int getMonth() {
        return this.getMonth(localtime);
    }

    public int getMonth(Calendar calendar) {
        return this.get(calendar, 2);
    }

    public int getSecond() {
        return this.getSecond(localtime);
    }

    public int getSecond(Calendar calendar) {
        return this.get(calendar, 13);
    }

    public int getYear() {
        return this.getYear(localtime);
    }

    public int getYear(Calendar calendar) {
        return this.get(calendar, 1);
    }

    public Time subtract(Duration duration) {
        return Time.milliseconds(this.getMilliseconds() - duration.getMilliseconds());
    }

    public Duration subtract(Time that) {
        return Duration.milliseconds(this.getMilliseconds() - that.getMilliseconds());
    }

    public Date toDate() {
        return new Date(this.getMilliseconds());
    }

    public String toDateString() {
        return this.toDateString(localtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDateString(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateFormat.setCalendar(calendar);
                return dateFormat.format(new Date(this.getMilliseconds())).toLowerCase();
            }
        }
    }

    @Override
    public String toString() {
        return this.toDateString() + "-" + this.toTimeString();
    }

    public String toString(Calendar calendar, String format) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(format);
        dateTimeFormat.setCalendar(calendar == null ? localtime : calendar);
        return dateTimeFormat.format(new Date(this.getMilliseconds()));
    }

    public String toString(String format) {
        return this.toString(null, format);
    }
}

