/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.annotations;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.mergedresources.annotations.ContributionScanner;
import org.wicketstuff.mergedresources.annotations.CssContribution;
import org.wicketstuff.mergedresources.annotations.CssContributions;
import org.wicketstuff.mergedresources.annotations.JsContribution;

public class HeaderContribution
extends AbstractHeaderContributor {
    private static final long serialVersionUID = 1L;
    private final List<IHeaderContributor> _headerContributors = new ArrayList<IHeaderContributor>(5);

    public HeaderContribution(Class<? extends Component> scope) {
        this.addJsContributions(scope, scope.getAnnotation(JsContribution.class));
        this.addCssContributions(scope, scope.getAnnotation(CssContribution.class));
        CssContributions cssMulti = scope.getAnnotation(CssContributions.class);
        if (cssMulti != null) {
            for (CssContribution css : cssMulti.value()) {
                this.addCssContributions(scope, css);
            }
        }
    }

    private void addCssContributions(Class<? extends Component> scope, CssContribution css) {
        if (css != null) {
            String[] stylesheets = this.replaceDefault(css.value(), ContributionScanner.getDefaultCssFile(scope.getSimpleName(), css.media()));
            String stylesheetsMedia = Strings.isEmpty((CharSequence)css.media()) ? null : css.media();
            for (String stylesheet : stylesheets) {
                if (stylesheetsMedia == null) {
                    this._headerContributors.add((IHeaderContributor)CSSPackageResource.getHeaderContribution(scope, (String)stylesheet));
                    continue;
                }
                this._headerContributors.add((IHeaderContributor)CSSPackageResource.getHeaderContribution(scope, (String)stylesheet, (String)stylesheetsMedia));
            }
        }
    }

    private void addJsContributions(Class<? extends Component> scope, JsContribution js) {
        if (js != null) {
            String[] scripts;
            for (String script : scripts = this.replaceDefault(js.value(), scope.getSimpleName() + ".js")) {
                this._headerContributors.add((IHeaderContributor)JavascriptPackageResource.getHeaderContribution(scope, (String)script));
            }
        }
    }

    private String[] replaceDefault(String[] files, String defaulFile) {
        for (int i = 0; i < files.length; ++i) {
            if (!Strings.isEmpty((CharSequence)files[i])) continue;
            files[i] = defaulFile;
        }
        return files;
    }

    public IHeaderContributor[] getHeaderContributors() {
        return this._headerContributors.toArray(new IHeaderContributor[this._headerContributors.size()]);
    }
}

