/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.resources;

import at.molindo.utils.io.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.preprocess.IResourcePreProcessor;

public class MergedResourceStream
implements IResourceStream {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = LoggerFactory.getLogger(MergedResourceStream.class);
    private final ResourceSpec[] _specs;
    private Locale _locale;
    private final String _style;
    private LocalizedMergedResourceStream _localizedMergedResourceStream;
    private final IResourcePreProcessor _preProcessor;

    @Deprecated
    public MergedResourceStream(Class<?>[] scopes, String[] files, Locale locale, String style) {
        this(ResourceSpec.toResourceSpecs(scopes, files), locale, style, null);
    }

    public MergedResourceStream(ResourceSpec[] specs, Locale locale, String style, IResourcePreProcessor preProcessor) {
        this._specs = (ResourceSpec[])specs.clone();
        this._locale = locale;
        this._style = style;
        this._preProcessor = preProcessor;
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return this.getLocalizedMergedResourceStream().getContentType();
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.getLocalizedMergedResourceStream().getInputStream();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public long length() {
        return this.getLocalizedMergedResourceStream().getContent().length;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Time lastModifiedTime() {
        return this.getLocalizedMergedResourceStream().getLastModifiedTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalizedMergedResourceStream getLocalizedMergedResourceStream() {
        MergedResourceStream mergedResourceStream = this;
        synchronized (mergedResourceStream) {
            if (this._localizedMergedResourceStream == null) {
                this._localizedMergedResourceStream = new LocalizedMergedResourceStream();
            }
            return this._localizedMergedResourceStream;
        }
    }

    protected byte[] toContent(byte[] content) {
        return content;
    }

    public boolean isPlainText() {
        return true;
    }

    public byte[] preProcess(ResourceSpec resourceSpec, byte[] content) {
        return this._preProcessor != null ? this._preProcessor.preProcess(resourceSpec, content) : content;
    }

    private final class LocalizedMergedResourceStream
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final byte[] _content;
        private final String _contentType;
        private final Time _lastModifiedTime;

        private LocalizedMergedResourceStream() {
            Time max = null;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            ArrayList<IResourceStream> resourceStreams = new ArrayList<IResourceStream>(MergedResourceStream.this._specs.length);
            String contentType = null;
            for (int i = 0; i < MergedResourceStream.this._specs.length; ++i) {
                Class<?> scope = MergedResourceStream.this._specs[i].getScope();
                String fileName = MergedResourceStream.this._specs[i].getFile();
                IResourceStream resourceStream = this.findResourceStream(scope, fileName);
                if (contentType != null) {
                    if (resourceStream.getContentType() != null && !contentType.equalsIgnoreCase(resourceStream.getContentType())) {
                        log.warn("content types of merged resources don't match: '" + resourceStream.getContentType() + "' and '" + contentType + "'");
                    }
                } else {
                    contentType = resourceStream.getContentType();
                }
                try {
                    Time lastModified = resourceStream.lastModifiedTime();
                    if (max == null || lastModified != null && lastModified.after((AbstractTimeValue)max)) {
                        max = lastModified;
                    }
                    if (i > 0) {
                        this.writeFileSeparator(out);
                    }
                    byte[] preprocessed = MergedResourceStream.this.preProcess(MergedResourceStream.this._specs[i], StreamUtils.bytes((InputStream)resourceStream.getInputStream()));
                    this.writeContent(out, new ByteArrayInputStream(preprocessed));
                    resourceStreams.add(resourceStream);
                    continue;
                }
                catch (IOException e) {
                    throw new WicketRuntimeException("failed to read from " + resourceStream, (Throwable)e);
                }
                catch (ResourceStreamNotFoundException e) {
                    throw new WicketRuntimeException("did not find resource", (Throwable)e);
                }
                finally {
                    try {
                        if (resourceStream != null) {
                            resourceStream.close();
                        }
                    }
                    catch (IOException e) {
                        log.warn("error while closing reader", (Throwable)e);
                    }
                }
            }
            this._contentType = contentType;
            this._content = MergedResourceStream.this.toContent(MergedResourceStream.this.preProcess(null, out.toByteArray()));
            this._lastModifiedTime = max == null ? Time.now() : max;
            this.watchForChanges(resourceStreams);
        }

        private IResourceStream findResourceStream(Class<?> scope, String fileName) {
            String path = Strings.beforeLast((String)scope.getName(), (char)'.').replace('.', '/') + '/' + Strings.beforeLast((String)fileName, (char)'.');
            ResourceNameIterator iter = new ResourceNameIterator(path, MergedResourceStream.this._style, MergedResourceStream.this._locale, Strings.afterLast((String)fileName, (char)'.'));
            IResourceStream resourceStream = null;
            while (resourceStream == null && iter.hasNext()) {
                String resourceName = iter.next();
                resourceStream = Application.get().getResourceSettings().getResourceStreamLocator().locate(scope, resourceName, MergedResourceStream.this._style, MergedResourceStream.this._locale, null);
            }
            if (resourceStream == null) {
                throw new WicketRuntimeException("did not find IResourceStream for " + Arrays.asList(scope, fileName, MergedResourceStream.this._style, MergedResourceStream.this._locale));
            }
            return resourceStream;
        }

        private void writeContent(OutputStream out, InputStream resourceStream) throws IOException {
            StreamUtils.copy((InputStream)resourceStream, (OutputStream)out);
            out.flush();
        }

        private void writeFileSeparator(ByteArrayOutputStream out) throws IOException {
            out.write(this.getFileSeparator());
        }

        private byte[] getFileSeparator() {
            return MergedResourceStream.this.isPlainText() ? "\n\n".getBytes() : new byte[]{};
        }

        private void watchForChanges(final List<IResourceStream> resourceStreams) {
            final IModificationWatcher watcher = Application.get().getResourceSettings().getResourceWatcher(true);
            if (watcher != null) {
                IChangeListener listener = new IChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onChange() {
                        log.info("merged resource has changed");
                        MergedResourceStream mergedResourceStream = MergedResourceStream.this;
                        synchronized (mergedResourceStream) {
                            for (IResourceStream resourceStream : resourceStreams) {
                                watcher.remove((IModifiable)resourceStream);
                            }
                            MergedResourceStream.this._localizedMergedResourceStream = null;
                        }
                    }
                };
                for (IResourceStream resourceStream : resourceStreams) {
                    watcher.add((IModifiable)resourceStream, listener);
                }
            }
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.getContent());
        }

        public byte[] getContent() {
            return this._content;
        }

        public Time getLastModifiedTime() {
            return this._lastModifiedTime;
        }

        public String getContentType() {
            return this._contentType;
        }
    }
}

