/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.util;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.apache.wicket.request.target.coding.BookmarkablePageRequestTargetUrlCodingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectStrategy
extends BookmarkablePageRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger(RedirectStrategy.class);
    private final String _redirectPath;

    public RedirectStrategy(String mountPath, String pageMapName, String redirectPath) {
        super(mountPath, WebPage.class, pageMapName);
        this._redirectPath = redirectPath;
    }

    public RedirectStrategy(String mountPath, String redirectPath) {
        this(mountPath, null, redirectPath);
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        if (log.isDebugEnabled()) {
            WebRequest r = (WebRequest)RequestCycle.get().getRequest();
            String ref = r.getHttpServletRequest().getHeader("Referer");
            String requested = r.getURL();
            log.debug("redirecting request coming from " + ref + " to " + requested + " to " + this._redirectPath);
        }
        return new RedirectRequestTarget(this._redirectPath);
    }
}

