/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.dao;

import at.mukprojects.exclycore.model.ExclyDate;
import at.mukprojects.exclycore.model.ExclyDateBlank;
import at.mukprojects.exclycore.model.ExclyDateError;
import at.mukprojects.exclycore.model.ExclyDouble;
import at.mukprojects.exclycore.model.ExclyDoubleBlank;
import at.mukprojects.exclycore.model.ExclyDoubleError;
import at.mukprojects.exclycore.model.ExclyInteger;
import at.mukprojects.exclycore.model.ExclyIntegerBlank;
import at.mukprojects.exclycore.model.ExclyIntegerError;
import at.mukprojects.exclycore.model.ExclyLong;
import at.mukprojects.exclycore.model.ExclyLongBlank;
import at.mukprojects.exclycore.model.ExclyLongError;
import at.mukprojects.exclycore.model.ExclyString;
import at.mukprojects.exclycore.model.ExclyStringError;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XLSXReader {
    private static final Logger log = LoggerFactory.getLogger(XLSXReader.class);
    private static final String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy'T'HH:mm:ss.SSS'Z'", "MM/dd/yyyy'T'HH:mm:ss.SSSZ", "MM/dd/yyyy'T'HH:mm:ss.SSS", "MM/dd/yyyy'T'HH:mm:ssZ", "MM/dd/yyyy'T'HH:mm:ss", "yyyy:MM:dd HH:mm:ss", "yyyyMMdd", "dd.MM.yyyy", "MM/dd/yyyy"};

    protected boolean isNumeric(String str) {
        return str.matches("\\d+(\\.\\d*)?(\\,\\d*)?|\\,\\d+") || str.matches("\\d+(\\,\\d*)?(\\.\\d*)?|\\.\\d+");
    }

    protected boolean isNumericGerman(String str) {
        return str.matches("\\d+(\\.\\d*)?(\\,\\d*)?|\\,\\d+");
    }

    protected boolean isNumericUK(String str) {
        return str.matches("\\d+(\\,\\d*)?(\\.\\d*)?|\\.\\d+");
    }

    protected boolean startsWithNumeric(String str) {
        return str.matches("^[0-9]+[0-9a-zA-Z\u00e4\u00fc\u00f6\u00c4\u00dc\u00d6 ]*");
    }

    public ExclyString readStringCellValue(Cell cell) {
        ExclyString output = null;
        if (cell == null) {
            return new ExclyStringError();
        }
        try {
            output = this.readString(cell, cell.getCellType());
        }
        catch (Exception e) {
            log.error("The reader was unable to read the data from cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")", (Throwable)e);
            output = new ExclyStringError();
        }
        return output;
    }

    private ExclyString readString(Cell cell, int type) throws Exception {
        ExclyString output = null;
        if (type == 1) {
            output = new ExclyString(cell.getStringCellValue());
        } else if (type == 5) {
            output = new ExclyStringError();
        } else if (type == 2) {
            int formulaType = cell.getCachedFormulaResultType();
            output = this.readString(cell, formulaType);
        } else if (type == 3) {
            output = new ExclyString("");
        } else if (type == 4) {
            Boolean data = cell.getBooleanCellValue();
            output = data.booleanValue() ? new ExclyString("WAHR") : new ExclyString("FALSCH");
        } else if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date data = cell.getDateCellValue();
            output = new ExclyString(data.toString());
        } else if (type == 0) {
            double cellValue = cell.getNumericCellValue();
            String data = String.valueOf(cellValue);
            if (cellValue % 1.0 == 0.0 && data.endsWith(".0")) {
                data = data.substring(0, data.length() - 2);
            }
            output = new ExclyString(data);
        } else {
            log.warn("The reader was unable to find a valid parser for the cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            output = new ExclyStringError();
        }
        return output;
    }

    public ExclyDouble readDoubleCellValue(Cell cell) {
        ExclyDouble output = null;
        if (cell == null) {
            return new ExclyDoubleError();
        }
        try {
            output = this.readDouble(cell, cell.getCellType());
        }
        catch (Exception e) {
            log.error("The reader was unable to read the data from cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")", (Throwable)e);
            output = new ExclyDoubleError();
        }
        return output;
    }

    private ExclyDouble readDouble(Cell cell, int type) throws Exception {
        ExclyDouble output = null;
        if (type == 1) {
            String data = cell.getStringCellValue();
            if (this.isNumericGerman(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.GERMAN).parse(data);
                output = new ExclyDouble(number.doubleValue());
            } else if (this.isNumericUK(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.UK).parse(data);
                output = new ExclyDouble(number.doubleValue());
            } else if (data.equals("") || data.equals(" ") || data.equals("-")) {
                output = new ExclyDoubleBlank();
            } else {
                output = new ExclyDoubleError();
                log.warn("The reader has expected a numeric value, but found a string value. [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            }
        } else if (type == 3) {
            output = new ExclyDoubleBlank();
        } else if (type == 2) {
            int formulaType = cell.getCachedFormulaResultType();
            output = this.readDouble(cell, formulaType);
        } else if (type == 4) {
            Boolean data = cell.getBooleanCellValue();
            output = data.booleanValue() ? new ExclyDouble(1.0) : new ExclyDouble(0.0);
        } else if (type == 0) {
            double data = cell.getNumericCellValue();
            output = new ExclyDouble(data);
        } else if (type == 5) {
            output = new ExclyDoubleError();
        } else {
            log.warn("The reader was unable to find a valid parser for the cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            output = new ExclyDoubleError();
        }
        return output;
    }

    public ExclyInteger readIntegerCellValue(Cell cell) {
        ExclyInteger output = null;
        if (cell == null) {
            return new ExclyIntegerError();
        }
        try {
            output = this.readInteger(cell, cell.getCellType());
        }
        catch (Exception e) {
            log.error("The reader was unable to read the data from cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")", (Throwable)e);
            output = new ExclyIntegerError();
        }
        return output;
    }

    private ExclyInteger readInteger(Cell cell, int type) throws Exception {
        ExclyInteger output = null;
        if (type == 1) {
            String data = cell.getStringCellValue();
            if (this.isNumericGerman(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.GERMAN).parse(data);
                output = new ExclyInteger(number.intValue());
            } else if (this.isNumericUK(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.UK).parse(data);
                output = new ExclyInteger(number.intValue());
            } else if (data.equals("") || data.equals(" ") || data.trim().equals("-")) {
                output = new ExclyIntegerBlank();
            } else {
                output = new ExclyIntegerError();
                log.warn("The reader has expected a numeric value, but found a string value. [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            }
        } else if (type == 3) {
            output = new ExclyIntegerBlank();
        } else if (type == 2) {
            int formulaType = cell.getCachedFormulaResultType();
            output = this.readInteger(cell, formulaType);
        } else if (type == 4) {
            Boolean data = cell.getBooleanCellValue();
            output = data.booleanValue() ? new ExclyInteger(1) : new ExclyInteger(0);
        } else if (type == 0) {
            double data = cell.getNumericCellValue();
            output = new ExclyInteger(data);
        } else if (type == 5) {
            output = new ExclyIntegerError();
        } else {
            log.warn("The reader was unable to find a valid parser for the cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            output = new ExclyIntegerError();
        }
        return output;
    }

    public ExclyLong readLongCellValue(Cell cell) {
        ExclyLong output = null;
        if (cell == null) {
            return new ExclyLongError();
        }
        try {
            output = this.readLong(cell, cell.getCellType());
        }
        catch (Exception e) {
            log.error("The reader was unable to read the data from cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")", (Throwable)e);
            output = new ExclyLongError();
        }
        return output;
    }

    private ExclyLong readLong(Cell cell, int type) throws Exception {
        ExclyLong output = null;
        if (type == 1) {
            String data = cell.getStringCellValue();
            if (this.isNumericGerman(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.GERMAN).parse(data);
                output = new ExclyLong(number.intValue());
            } else if (this.isNumericUK(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.UK).parse(data);
                output = new ExclyLong(number.intValue());
            } else if (data.equals("") || data.equals(" ") || data.equals("-")) {
                output = new ExclyLongBlank();
            } else {
                output = new ExclyLongError();
                log.warn("The reader has expected a numeric value, but found a string value. [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            }
        } else if (type == 3) {
            output = new ExclyLongBlank();
        } else if (type == 2) {
            int formulaType = cell.getCachedFormulaResultType();
            output = this.readLong(cell, formulaType);
        } else if (type == 4) {
            Boolean data = cell.getBooleanCellValue();
            output = data.booleanValue() ? new ExclyLong(1L) : new ExclyLong(0L);
        } else if (type == 0) {
            double data = cell.getNumericCellValue();
            output = new ExclyLong(data);
        } else if (type == 5) {
            output = new ExclyLongError();
        } else {
            log.warn("The reader was unable to find a valid parser for the cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            output = new ExclyLongError();
        }
        return output;
    }

    public ExclyDate readDateCellValue(Cell cell) {
        ExclyDate output = null;
        if (cell == null) {
            return new ExclyDateError();
        }
        try {
            output = this.readDate(cell, cell.getCellType());
        }
        catch (Exception e) {
            log.error("The reader was unable to read the data from cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")", (Throwable)e);
            output = new ExclyDateError();
        }
        return output;
    }

    private ExclyDate readDate(Cell cell, int type) throws Exception {
        ExclyDate output = null;
        if (type == 1) {
            String data = cell.getStringCellValue();
            if (this.isNumericGerman(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.GERMAN).parse(data);
                output = new ExclyDate(DateUtil.getJavaDate((double)number.intValue()));
            } else if (this.isNumericUK(data)) {
                Number number = NumberFormat.getNumberInstance(Locale.UK).parse(data);
                output = new ExclyDate(DateUtil.getJavaDate((double)number.intValue()));
            } else if (data.equals("") || data.equals(" ") || data.trim().equals("-")) {
                output = new ExclyDateBlank();
            } else {
                ExclyDate parsedDate = this.parse(cell.getStringCellValue());
                output = parsedDate;
            }
        } else if (type == 3) {
            output = new ExclyDateBlank();
        } else if (type == 2) {
            int formulaType = cell.getCachedFormulaResultType();
            output = this.readDate(cell, formulaType);
        } else if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date data = cell.getDateCellValue();
            output = new ExclyDate(data);
        } else if (type == 0) {
            double data = cell.getNumericCellValue();
            output = new ExclyDate(DateUtil.getJavaDate((double)data));
        } else if (type == 5) {
            output = new ExclyDateError();
        } else {
            log.warn("The reader was unable to find a valid parser for the cell [Row, Column] (" + cell.getRowIndex() + ", " + cell.getColumnIndex() + ")");
            output = new ExclyDateError();
        }
        return output;
    }

    private ExclyDate parse(String date) throws ParseException {
        if (date != null && !date.isEmpty()) {
            ExclyDate output = null;
            for (String format : formats) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    Date parsedDate = sdf.parse(date);
                    output = new ExclyDate(parsedDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (output != null) {
                return output;
            }
            throw new ParseException(date, 0);
        }
        throw new ParseException(date, 0);
    }
}

