/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.model;

import at.mukprojects.exclycore.model.ExclyDataType;
import at.mukprojects.exclycore.model.ExclyDoubleError;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExclyDouble
implements ExclyDataType,
Comparable<ExclyDouble> {
    protected boolean error;
    private Double data;

    public ExclyDouble(double data) {
        this.data = data;
        this.error = false;
    }

    @Override
    public void setCell(Cell cell) {
        this.setCell(cell, cell.getCellStyle());
    }

    @Override
    public void setCell(Cell cell, CellStyle cellStyle) {
        cell.setCellValue(this.data.doubleValue());
        cell.setCellStyle(cellStyle);
    }

    public double getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        return this.data + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.data);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.error ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExclyDouble other = (ExclyDouble)obj;
        if (Double.doubleToLongBits(this.data) != Double.doubleToLongBits(other.data)) {
            return false;
        }
        return this.error == other.error;
    }

    @Override
    public int compareTo(ExclyDouble other) {
        if (!this.error && other.error) {
            return -1;
        }
        if (this.error && !other.error) {
            return 1;
        }
        if (this.error && other.error) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public static ExclyDouble add(ExclyDouble ... values) {
        ExclyDoubleError error = null;
        Double data = null;
        for (ExclyDouble value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyDoubleError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyDoubleError();
            } else {
                data = data + value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDouble(data);
    }

    public static ExclyDouble sub(ExclyDouble ... values) {
        ExclyDoubleError error = null;
        Double data = null;
        for (ExclyDouble value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyDoubleError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyDoubleError();
            } else {
                data = data - value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDouble(data);
    }

    public static ExclyDouble multi(ExclyDouble ... values) {
        ExclyDoubleError error = null;
        Double data = null;
        for (ExclyDouble value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyDoubleError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyDoubleError();
            } else {
                data = data * value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDouble(data);
    }

    public static ExclyDouble div(ExclyDouble ... values) {
        ExclyDoubleError error = null;
        Double data = null;
        for (ExclyDouble value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyDoubleError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyDoubleError();
            } else {
                data = data / value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyDouble(data);
    }
}

