/*
 * Decompiled with CFR 0.152.
 */
package at.mukprojects.exclycore.model;

import at.mukprojects.exclycore.model.ExclyDataType;
import at.mukprojects.exclycore.model.ExclyStringError;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExclyString
implements ExclyDataType,
Comparable<ExclyString> {
    protected boolean error;
    private String data;

    public ExclyString(String data) {
        this.data = data;
        this.error = false;
    }

    @Override
    public void setCell(Cell cell) {
        this.setCell(cell, cell.getCellStyle());
    }

    @Override
    public void setCell(Cell cell, CellStyle cellStyle) {
        cell.setCellValue(this.data);
        cell.setCellStyle(cellStyle);
    }

    public String getData() {
        return this.data;
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.error ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExclyString other = (ExclyString)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return this.error == other.error;
    }

    @Override
    public int compareTo(ExclyString other) {
        if (!this.error && other.error) {
            return -1;
        }
        if (this.error && !other.error) {
            return 1;
        }
        if (this.error && other.error) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public boolean startsWith(ExclyString other) {
        if (!this.error && other.error) {
            return false;
        }
        if (this.error && !other.error) {
            return false;
        }
        if (this.error && other.error) {
            return false;
        }
        if (this.data == null) {
            return false;
        }
        if (other.data == null) {
            return false;
        }
        return this.data.startsWith(other.data);
    }

    public static ExclyString append(ExclyString ... values) {
        ExclyStringError error = null;
        String data = null;
        for (ExclyString value : values) {
            if (data == null) {
                if (value.isError()) {
                    error = new ExclyStringError();
                } else {
                    data = value.getData();
                }
            } else if (value.isError()) {
                error = new ExclyStringError();
            } else {
                data = data + value.getData();
            }
            if (error == null) continue;
            return error;
        }
        return new ExclyString(data);
    }
}

