/*
 * Decompiled with CFR 0.152.
 */
package at.noahb.smartinvs.opener;

import at.noahb.smartinvs.InventoryManager;
import at.noahb.smartinvs.SmartInventory;
import at.noahb.smartinvs.content.InventoryContents;
import at.noahb.smartinvs.opener.InventoryOpener;
import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ChestInventoryOpener
implements InventoryOpener {
    @Override
    public Inventory open(SmartInventory inv, Player player) {
        Preconditions.checkArgument((inv.getColumns() == 9 ? 1 : 0) != 0, (String)"The column count for the chest inventory must be 9, found: %s.", (int)inv.getColumns());
        Preconditions.checkArgument((inv.getRows() >= 1 && inv.getRows() <= 6 ? 1 : 0) != 0, (String)"The row count for the chest inventory must be between 1 and 6, found: %s", (int)inv.getRows());
        InventoryManager manager = inv.getManager();
        Inventory handle = Bukkit.createInventory((InventoryHolder)player, (int)(inv.getRows() * inv.getColumns()), (Component)Component.text((String)inv.getTitle()));
        manager.getContents(player).ifPresent(inventoryContents -> this.fill(handle, (InventoryContents)inventoryContents));
        player.openInventory(handle);
        return handle;
    }

    @Override
    public boolean supports(InventoryType type) {
        return type == InventoryType.CHEST || type == InventoryType.ENDER_CHEST;
    }
}

