/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.crypto;

import at.qubic.api.crypto.FourQ;
import at.qubic.api.crypto.KangarooTwelve;
import at.qubic.api.crypto.QubicFourQ;
import at.qubic.api.exception.InvalidIdentityException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdentityUtil.class);
    private static final char UPPER_CASE_OFFSET = 'A';
    private static final char LOWER_CASE_OFFSET = 'a';
    private final boolean verify;
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("[A-Z]{60}");
    private static final Pattern SEED_PATTERN = Pattern.compile("[a-z]{55}");
    private final FourQ fourQ;

    public IdentityUtil(boolean doVerification, FourQ fourQ) {
        this.verify = doVerification;
        this.fourQ = fourQ;
    }

    public IdentityUtil() {
        this(true, new QubicFourQ());
    }

    public byte[] getSubSeedFromSeed(String seed) {
        if (this.verify) {
            IdentityUtil.verifyIdentity(() -> this.isValidSeed(seed), () -> String.format("Invalid seed: [%s].", seed));
        }
        byte[] seedArr = IdentityUtil.toSeedBytes(seed);
        return KangarooTwelve.hash(seedArr, 32);
    }

    public byte[] getPrivateKeyFromSubSeed(byte[] subSeed) {
        if (this.verify) {
            IdentityUtil.verifyIdentity(() -> ArrayUtils.getLength((Object)subSeed) == 32, () -> "Invalid sub seed length.");
        }
        return KangarooTwelve.hash(subSeed, 32);
    }

    public byte[] getPublicKeyFromPrivateKey(byte[] privateKey) {
        if (this.verify) {
            IdentityUtil.verifyIdentity(() -> ArrayUtils.getLength((Object)privateKey) == 32, () -> "Invalid private key length.");
        }
        return this.fourQ.ecc_mul_fixed(privateKey);
    }

    public byte[] getPublicKeyFromSeed(String seed) {
        return this.getPublicKeyFromSubSeed(this.getSubSeedFromSeed(seed));
    }

    public byte[] getPublicKeyFromSubSeed(byte[] subSeed) {
        return this.getPublicKeyFromPrivateKey(this.getPrivateKeyFromSubSeed(subSeed));
    }

    public byte[] getPublicKeyFromIdentity(String identity) {
        if (this.verify) {
            IdentityUtil.verifyIdentity(() -> IdentityUtil.isValidIdentityString(identity), () -> String.format("Invalid identity: [%s]", identity));
        }
        byte[] publicKey = IdentityUtil.convertIdentityToPublicKey(identity);
        IdentityUtil.verifyIdentityChecksum(identity, publicKey);
        return publicKey;
    }

    public String getIdentityFromPublicKey(byte[] publicKey) {
        return this.getIdentityFromPublicKey(publicKey, 'A');
    }

    public String getTransactionHash(byte[] signedTxDigest) {
        return this.getIdentityFromPublicKey(signedTxDigest, 'a');
    }

    public boolean isValidSeed(String seed) {
        return SEED_PATTERN.matcher(StringUtils.defaultString((String)seed)).matches();
    }

    public boolean isValidIdentity(String identity) {
        if (IdentityUtil.isValidIdentityString(identity)) {
            try {
                byte[] publicKey = IdentityUtil.convertIdentityToPublicKey(identity);
                return IdentityUtil.isValidChecksum(identity, publicKey);
            }
            catch (InvalidIdentityException iie) {
                log.warn(iie.getMessage());
                return false;
            }
        }
        return false;
    }

    private static boolean isValidIdentityString(String identity) {
        return IDENTITY_PATTERN.matcher(StringUtils.defaultString((String)identity)).matches();
    }

    private static byte[] convertIdentityToPublicKey(String identity) {
        ByteBuffer buf = ByteBuffer.allocate(32);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long[] publicKeyLongs = new long[4];
        for (int i = 0; i < 4; ++i) {
            int j = 14;
            while (j-- > 0) {
                char character = identity.charAt(i * 14 + j);
                if (character < 'A' || character > 'Z') {
                    throw new InvalidIdentityException("Only characters A-Z are allowed.");
                }
                publicKeyLongs[i] = publicKeyLongs[i] * 26L + (long)(character - 65);
            }
            buf.putLong(publicKeyLongs[i]);
        }
        return buf.array();
    }

    private String getIdentityFromPublicKey(byte[] publicKey, char offset) {
        if (this.verify) {
            IdentityUtil.verifyIdentity(() -> ArrayUtils.getLength((Object)publicKey) == 32, () -> "Invalid public key length.");
        }
        StringBuilder identity = new StringBuilder();
        ByteBuffer publicKeyBuf = ByteBuffer.wrap(publicKey);
        publicKeyBuf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 4; ++i) {
            long publicKeyFragment = publicKeyBuf.getLong();
            for (int j = 0; j < 14; ++j) {
                long character = Long.remainderUnsigned(publicKeyFragment, 26L);
                identity.append((char)(character + (long)offset));
                publicKeyFragment = Long.divideUnsigned(publicKeyFragment, 26L);
            }
        }
        publicKeyBuf.clear();
        identity.append(IdentityUtil.getChecksum(publicKey, offset));
        return identity.toString();
    }

    private static String getPublicKeyChecksum(byte[] publicKey) {
        return IdentityUtil.getChecksum(publicKey, 'A');
    }

    private static String getChecksum(byte[] publicKey, char offset) {
        byte[] checksumBytes = KangarooTwelve.hash(publicKey, 4);
        int checksumInt = IdentityUtil.fromByteArray(checksumBytes) & 0x3FFFF;
        log.trace("Checksum int value [{}]. Bits: [{}].", (Object)checksumInt, (Object)Integer.toBinaryString(checksumInt));
        StringBuilder checksum = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            checksum.append((char)(checksumInt % 26 + offset));
            checksumInt /= 26;
        }
        return checksum.toString();
    }

    private static boolean isValidChecksum(String identity, byte[] publicKey) {
        String checksum = IdentityUtil.getPublicKeyChecksum(publicKey);
        boolean valid = checksum.equals(identity.substring(56));
        if (!valid) {
            log.warn("Identity [{}] has invalid checksum. Expected [{}]", (Object)identity, (Object)checksum);
        }
        return valid;
    }

    private static void verifyIdentityChecksum(String identity, byte[] publicKey) {
        IdentityUtil.verifyIdentity(() -> IdentityUtil.isValidChecksum(identity, publicKey), () -> String.format("Checksum of identity [%s] is not correct. Expected [%s] but was [%s].", identity, IdentityUtil.getPublicKeyChecksum(publicKey), StringUtils.substring((String)identity, (int)56)));
    }

    private static byte[] toSeedBytes(String seed) {
        byte[] seedArr = new byte[seed.length()];
        for (int i = 0; i < seedArr.length; ++i) {
            seedArr[i] = (byte)(seed.charAt(i) - 97);
        }
        return seedArr;
    }

    private static void verifyIdentity(BooleanSupplier condition, Supplier<String> messageSupplier) {
        if (!condition.getAsBoolean()) {
            String msg = messageSupplier.get();
            log.error(msg);
            throw new InvalidIdentityException(msg);
        }
    }

    private static int fromByteArray(byte[] bytes) {
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }
}

