/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.crypto;

import at.qubic.api.crypto.FourQ;
import at.qubic.api.crypto.SchnorrQubic;
import at.qubic.api.crypto.jna.QubicCryptoLib;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QubicFourQ
implements FourQ,
SchnorrQubic {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QubicFourQ.class);
    private final QubicCryptoLib lib;

    public QubicFourQ() {
        this("fourq-qubic");
    }

    public QubicFourQ(String libName) {
        log.info("Using fourq library: [{}].", (Object)libName);
        this.lib = (QubicCryptoLib)Native.load((String)libName, QubicCryptoLib.class);
    }

    @Override
    public byte[] ecc_mul_fixed(byte[] in) {
        Memory p = new Memory(64L);
        byte[] out = new byte[32];
        this.lib.ecc_mul_fixed(in, (Pointer)p);
        this.lib.encode((Pointer)p, out);
        return out;
    }

    @Override
    public void ecc_mul_fixed(byte[] in, byte[] out) {
        Memory p = new Memory(64L);
        this.lib.ecc_mul_fixed(in, (Pointer)p);
        this.lib.encode((Pointer)p, out);
    }

    @Override
    public byte[] sign(byte[] subSeed, byte[] publicKey, byte[] digest) {
        assert (subSeed.length >= 32);
        byte[] signature = new byte[64];
        this.lib.sign(subSeed, publicKey, digest, signature);
        return signature;
    }

    @Override
    public byte[] signWithNonceK(byte[] input, byte[] publicKey, byte[] digest) {
        assert (input.length >= 64);
        byte[] signature = new byte[64];
        this.lib.signWithNonceK(input, publicKey, digest, signature);
        return signature;
    }

    @Override
    public boolean verify(byte[] publicKey, byte[] messageDigest, byte[] signature) {
        return this.lib.verify(publicKey, messageDigest, signature);
    }
}

