/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain;

import at.qubic.api.domain.MessageType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QubicHeader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QubicHeader.class);
    public static final int HEADER_LENGTH = 8;
    private final int size;
    private final MessageType type;
    private final int dejavu;

    public static QubicHeader fromBytes(ByteBuffer buf) {
        if (log.isTraceEnabled()) {
            byte[] headerBytes = new byte[8];
            int position = buf.position();
            buf.get(headerBytes);
            log.trace("Header bytes: {}", (Object)Hex.encodeHexString((byte[])headerBytes));
            buf.position(position);
        }
        byte[] size = new byte[3];
        buf.get(size);
        return QubicHeader.builder().size(QubicHeader.bytesToSize(size)).type(MessageType.fromCode(buf.get())).dejavu(buf.getInt()).build();
    }

    public ByteBuffer toBytes(int capacity) {
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.put(QubicHeader.sizeToBytes(this.getSize()));
        buf.put(this.getType().getCode());
        buf.putInt(this.getDejavu());
        return buf;
    }

    private static int bytesToSize(byte[] sizeArr) {
        assert (sizeArr.length == 3);
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).put(sizeArr).rewind().getInt();
    }

    static byte[] sizeToBytes(int intSize) {
        if (intSize < 0) {
            String msg = String.format("Only positive values up to 3 bytes are supported. Value: [%d].", intSize);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] size = new byte[3];
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(intSize);
        buf.get(0, size, 0, 3);
        return size;
    }

    @Generated
    private static int $default$size() {
        return 8;
    }

    @Generated
    private static int $default$dejavu() {
        return Math.abs(ThreadLocalRandom.current().nextInt());
    }

    @Generated
    QubicHeader(int size, MessageType type, int dejavu) {
        this.size = size;
        this.type = type;
        this.dejavu = dejavu;
    }

    @Generated
    public static QubicHeaderBuilder builder() {
        return new QubicHeaderBuilder();
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public MessageType getType() {
        return this.type;
    }

    @Generated
    public int getDejavu() {
        return this.dejavu;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QubicHeader)) {
            return false;
        }
        QubicHeader other = (QubicHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getDejavu() != other.getDejavu()) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QubicHeader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        result = result * 59 + this.getDejavu();
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QubicHeader(size=" + this.getSize() + ", type=" + String.valueOf((Object)this.getType()) + ", dejavu=" + this.getDejavu() + ")";
    }

    @Generated
    public static class QubicHeaderBuilder {
        @Generated
        private boolean size$set;
        @Generated
        private int size$value;
        @Generated
        private MessageType type;
        @Generated
        private boolean dejavu$set;
        @Generated
        private int dejavu$value;

        @Generated
        QubicHeaderBuilder() {
        }

        @Generated
        public QubicHeaderBuilder size(int size) {
            this.size$value = size;
            this.size$set = true;
            return this;
        }

        @Generated
        public QubicHeaderBuilder type(MessageType type) {
            this.type = type;
            return this;
        }

        @Generated
        public QubicHeaderBuilder dejavu(int dejavu) {
            this.dejavu$value = dejavu;
            this.dejavu$set = true;
            return this;
        }

        @Generated
        public QubicHeader build() {
            int size$value = this.size$value;
            if (!this.size$set) {
                size$value = QubicHeader.$default$size();
            }
            int dejavu$value = this.dejavu$value;
            if (!this.dejavu$set) {
                dejavu$value = QubicHeader.$default$dejavu();
            }
            return new QubicHeader(size$value, this.type, dejavu$value);
        }

        @Generated
        public String toString() {
            return "QubicHeader.QubicHeaderBuilder(size$value=" + this.size$value + ", type=" + String.valueOf((Object)this.type) + ", dejavu$value=" + this.dejavu$value + ")";
        }
    }
}

