/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain;

import at.qubic.api.domain.MessageType;
import at.qubic.api.domain.QubicHeader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QubicMessage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QubicMessage.class);
    private final QubicHeader header;
    private final byte[] payload;

    public byte[] toBytes() {
        return this.header.toBytes(this.header.getSize()).put(this.payload).array();
    }

    public static QubicMessage fromBytes(ByteBuffer buf) {
        QubicHeader header = QubicHeader.fromBytes(buf);
        log.debug("Read header: {}.", (Object)header.getType());
        int payloadSize = header.getSize() - 8;
        if (payloadSize > buf.remaining()) {
            String message = String.format("Unprocessable byte buffer. Expected size: [%s]. Remaining bytes: [%s]", header.getSize(), buf.remaining());
            log.error(message);
            throw new IllegalStateException(message);
        }
        log.debug("Received payload with [{}] bytes.", (Object)payloadSize);
        byte[] payload = new byte[payloadSize];
        if (payloadSize > 0) {
            buf.get(payload);
            log.trace("Payload (bytes): {}", (Object)payload);
            log.trace("Payload (hex): {}", (Object)Hex.encodeHexString((byte[])payload));
        } else if (header.getType() != MessageType.END_RESPONSE) {
            log.warn("Payload is empty. Header: {}.", (Object)header);
        }
        return QubicMessage.builder().header(header).payload(payload).build();
    }

    @Generated
    private static byte[] $default$payload() {
        return new byte[0];
    }

    @Generated
    QubicMessage(QubicHeader header, byte[] payload) {
        this.header = header;
        this.payload = payload;
    }

    @Generated
    public static QubicMessageBuilder builder() {
        return new QubicMessageBuilder();
    }

    @Generated
    public QubicHeader getHeader() {
        return this.header;
    }

    @Generated
    public byte[] getPayload() {
        return this.payload;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QubicMessage)) {
            return false;
        }
        QubicMessage other = (QubicMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QubicHeader this$header = this.getHeader();
        QubicHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QubicMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QubicHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    @Generated
    public static class QubicMessageBuilder {
        @Generated
        private QubicHeader header;
        @Generated
        private boolean payload$set;
        @Generated
        private byte[] payload$value;

        @Generated
        QubicMessageBuilder() {
        }

        @Generated
        public QubicMessageBuilder header(QubicHeader header) {
            this.header = header;
            return this;
        }

        @Generated
        public QubicMessageBuilder payload(byte[] payload) {
            this.payload$value = payload;
            this.payload$set = true;
            return this;
        }

        @Generated
        public QubicMessage build() {
            byte[] payload$value = this.payload$value;
            if (!this.payload$set) {
                payload$value = QubicMessage.$default$payload();
            }
            return new QubicMessage(this.header, payload$value);
        }

        @Generated
        public String toString() {
            return "QubicMessage.QubicMessageBuilder(header=" + String.valueOf(this.header) + ", payload$value=" + Arrays.toString(this.payload$value) + ")";
        }
    }
}

