/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.qx.request;

import at.qubic.api.util.AssetUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;

public class QxAssetOrderData {
    public static final short SIZE = 56;
    private final byte[] assetIssuer;
    private final String assetName;
    private final long price;
    private final long numberOfShares;

    public byte[] toBytes() {
        return ByteBuffer.allocate(56).order(ByteOrder.LITTLE_ENDIAN).put(this.assetIssuer).put(AssetUtil.nameTo8Bytes(this.assetName)).putLong(this.price).putLong(this.numberOfShares).array();
    }

    private String issuerPublicKey() {
        return this.assetIssuer == null ? null : Hex.encodeHexString((byte[])this.assetIssuer);
    }

    @Generated
    QxAssetOrderData(byte[] assetIssuer, String assetName, long price, long numberOfShares) {
        this.assetIssuer = assetIssuer;
        this.assetName = assetName;
        this.price = price;
        this.numberOfShares = numberOfShares;
    }

    @Generated
    public static QxAssetOrderDataBuilder builder() {
        return new QxAssetOrderDataBuilder();
    }

    @Generated
    public String toString() {
        return "QxAssetOrderData(assetName=" + this.getAssetName() + ", price=" + this.getPrice() + ", numberOfShares=" + this.getNumberOfShares() + ", issuerPublicKey=" + this.issuerPublicKey() + ")";
    }

    @Generated
    public byte[] getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public String getAssetName() {
        return this.assetName;
    }

    @Generated
    public long getPrice() {
        return this.price;
    }

    @Generated
    public long getNumberOfShares() {
        return this.numberOfShares;
    }

    @Generated
    public static class QxAssetOrderDataBuilder {
        @Generated
        private byte[] assetIssuer;
        @Generated
        private String assetName;
        @Generated
        private long price;
        @Generated
        private long numberOfShares;

        @Generated
        QxAssetOrderDataBuilder() {
        }

        @Generated
        public QxAssetOrderDataBuilder assetIssuer(byte[] assetIssuer) {
            this.assetIssuer = assetIssuer;
            return this;
        }

        @Generated
        public QxAssetOrderDataBuilder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        @Generated
        public QxAssetOrderDataBuilder price(long price) {
            this.price = price;
            return this;
        }

        @Generated
        public QxAssetOrderDataBuilder numberOfShares(long numberOfShares) {
            this.numberOfShares = numberOfShares;
            return this;
        }

        @Generated
        public QxAssetOrderData build() {
            return new QxAssetOrderData(this.assetIssuer, this.assetName, this.price, this.numberOfShares);
        }

        @Generated
        public String toString() {
            return "QxAssetOrderData.QxAssetOrderDataBuilder(assetIssuer=" + Arrays.toString(this.assetIssuer) + ", assetName=" + this.assetName + ", price=" + this.price + ", numberOfShares=" + this.numberOfShares + ")";
        }
    }
}

