/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.qx.request;

import at.qubic.api.domain.qx.Qx;
import at.qubic.api.domain.qx.request.QxOrder;
import at.qubic.api.util.AssetUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;

public class QxTransferAssetOrder
implements QxOrder {
    public static final short SIZE = 80;
    private final byte[] assetIssuer;
    private final byte[] newOwnerAndPossessor;
    private final String assetName;
    private final long numberOfUnits;

    @Override
    public long getAmount() {
        return 1000000L;
    }

    @Override
    public short getInputType() {
        return Qx.Procedure.QX_TRANSFER_SHARE.getCode();
    }

    @Override
    public byte[] toBytes() {
        return ByteBuffer.allocate(80).order(ByteOrder.LITTLE_ENDIAN).put(this.assetIssuer).put(this.newOwnerAndPossessor).put(AssetUtil.nameTo8Bytes(this.assetName)).putLong(this.numberOfUnits).array();
    }

    @Override
    public String getOrderDescription() {
        return "transfer asset";
    }

    @Generated
    QxTransferAssetOrder(byte[] assetIssuer, byte[] newOwnerAndPossessor, String assetName, long numberOfUnits) {
        this.assetIssuer = assetIssuer;
        this.newOwnerAndPossessor = newOwnerAndPossessor;
        this.assetName = assetName;
        this.numberOfUnits = numberOfUnits;
    }

    @Generated
    public static QxTransferAssetOrderBuilder builder() {
        return new QxTransferAssetOrderBuilder();
    }

    @Generated
    public String toString() {
        return "QxTransferAssetOrder(assetName=" + this.getAssetName() + ", numberOfUnits=" + this.getNumberOfUnits() + ")";
    }

    @Generated
    public byte[] getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public byte[] getNewOwnerAndPossessor() {
        return this.newOwnerAndPossessor;
    }

    @Generated
    public String getAssetName() {
        return this.assetName;
    }

    @Generated
    public long getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @Generated
    public static class QxTransferAssetOrderBuilder {
        @Generated
        private byte[] assetIssuer;
        @Generated
        private byte[] newOwnerAndPossessor;
        @Generated
        private String assetName;
        @Generated
        private long numberOfUnits;

        @Generated
        QxTransferAssetOrderBuilder() {
        }

        @Generated
        public QxTransferAssetOrderBuilder assetIssuer(byte[] assetIssuer) {
            this.assetIssuer = assetIssuer;
            return this;
        }

        @Generated
        public QxTransferAssetOrderBuilder newOwnerAndPossessor(byte[] newOwnerAndPossessor) {
            this.newOwnerAndPossessor = newOwnerAndPossessor;
            return this;
        }

        @Generated
        public QxTransferAssetOrderBuilder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        @Generated
        public QxTransferAssetOrderBuilder numberOfUnits(long numberOfUnits) {
            this.numberOfUnits = numberOfUnits;
            return this;
        }

        @Generated
        public QxTransferAssetOrder build() {
            return new QxTransferAssetOrder(this.assetIssuer, this.newOwnerAndPossessor, this.assetName, this.numberOfUnits);
        }

        @Generated
        public String toString() {
            return "QxTransferAssetOrder.QxTransferAssetOrderBuilder(assetIssuer=" + Arrays.toString(this.assetIssuer) + ", newOwnerAndPossessor=" + Arrays.toString(this.newOwnerAndPossessor) + ", assetName=" + this.assetName + ", numberOfUnits=" + this.numberOfUnits + ")";
        }
    }
}

