/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.qx.response;

import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetOrder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetOrder.class);
    public static final int ORDER_COUNT = 256;
    public static final int ORDER_SIZE_BYTES = 48;
    private final byte[] entity;
    private final long price;
    private final long numberOfShares;

    public static List<AssetOrder> getAssetOrders(byte[] input) {
        ByteBuffer buffer = ByteBuffer.wrap(input);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<AssetOrder> assetOrders = new ArrayList<AssetOrder>(256);
        AssetOrder assetOrder = AssetOrder.fromBytes(buffer);
        while (!assetOrder.isEmpty() && assetOrders.size() < 255) {
            assetOrders.add(assetOrder);
            assetOrder = AssetOrder.fromBytes(buffer);
        }
        return assetOrders;
    }

    private static AssetOrder fromBytes(ByteBuffer buffer) {
        return AssetOrder.builder().entity(BufferUtil.getByteArray(buffer, 32)).price(buffer.getLong()).numberOfShares(buffer.getLong()).build();
    }

    public boolean isEmpty() {
        return ArrayUtils.isEmpty((byte[])this.entity) || Arrays.equals(this.entity, new byte[32]);
    }

    public String toString() {
        return "AssetOrder(entity=" + (this.entity == null ? null : Hex.encodeHexString((byte[])this.entity)) + ", price=" + this.price + ", numberOfShares=" + this.numberOfShares + ")";
    }

    @Generated
    AssetOrder(byte[] entity, long price, long numberOfShares) {
        this.entity = entity;
        this.price = price;
        this.numberOfShares = numberOfShares;
    }

    @Generated
    public static AssetOrderBuilder builder() {
        return new AssetOrderBuilder();
    }

    @Generated
    public byte[] getEntity() {
        return this.entity;
    }

    @Generated
    public long getPrice() {
        return this.price;
    }

    @Generated
    public long getNumberOfShares() {
        return this.numberOfShares;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetOrder)) {
            return false;
        }
        AssetOrder other = (AssetOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPrice() != other.getPrice()) {
            return false;
        }
        if (this.getNumberOfShares() != other.getNumberOfShares()) {
            return false;
        }
        return Arrays.equals(this.getEntity(), other.getEntity());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = this.getPrice();
        result = result * 59 + (int)($price >>> 32 ^ $price);
        long $numberOfShares = this.getNumberOfShares();
        result = result * 59 + (int)($numberOfShares >>> 32 ^ $numberOfShares);
        result = result * 59 + Arrays.hashCode(this.getEntity());
        return result;
    }

    @Generated
    public static class AssetOrderBuilder {
        @Generated
        private byte[] entity;
        @Generated
        private long price;
        @Generated
        private long numberOfShares;

        @Generated
        AssetOrderBuilder() {
        }

        @Generated
        public AssetOrderBuilder entity(byte[] entity) {
            this.entity = entity;
            return this;
        }

        @Generated
        public AssetOrderBuilder price(long price) {
            this.price = price;
            return this;
        }

        @Generated
        public AssetOrderBuilder numberOfShares(long numberOfShares) {
            this.numberOfShares = numberOfShares;
            return this;
        }

        @Generated
        public AssetOrder build() {
            return new AssetOrder(this.entity, this.price, this.numberOfShares);
        }

        @Generated
        public String toString() {
            return "AssetOrder.AssetOrderBuilder(entity=" + Arrays.toString(this.entity) + ", price=" + this.price + ", numberOfShares=" + this.numberOfShares + ")";
        }
    }
}

