/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.qx.response;

import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityOrder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityOrder.class);
    public static final int ORDER_COUNT = 256;
    public static final int ORDER_SIZE_BYTES = 56;
    private final byte[] issuer;
    private final byte[] assetName;
    private final long price;
    private final long numberOfShares;

    public static List<EntityOrder> getEntityOrders(byte[] input) {
        ByteBuffer buffer = ByteBuffer.wrap(input);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<EntityOrder> entityOrders = new ArrayList<EntityOrder>(256);
        EntityOrder entityOrder = EntityOrder.fromBytes(buffer);
        while (!entityOrder.isEmpty() && entityOrders.size() < 255) {
            entityOrders.add(entityOrder);
            entityOrder = EntityOrder.fromBytes(buffer);
        }
        return entityOrders;
    }

    private static EntityOrder fromBytes(ByteBuffer buffer) {
        return EntityOrder.builder().issuer(BufferUtil.getByteArray(buffer, 32)).assetName(BufferUtil.getByteArray(buffer, 8)).price(buffer.getLong()).numberOfShares(buffer.getLong()).build();
    }

    public boolean isEmpty() {
        return this.price == 0L || this.numberOfShares == 0L || ArrayUtils.isEmpty((byte[])this.assetName) || Arrays.equals(this.assetName, new byte[32]);
    }

    public String toString() {
        return "EntityOrder{issuer=" + (this.issuer == null ? null : Hex.encodeHexString((byte[])this.issuer)) + ", assetName=" + this.getAssetNameString() + ", price=" + this.price + ", numberOfShares=" + this.numberOfShares + "}";
    }

    public String getAssetNameString() {
        return this.assetName == null ? "" : new String(this.assetName, StandardCharsets.US_ASCII).trim();
    }

    @Generated
    EntityOrder(byte[] issuer, byte[] assetName, long price, long numberOfShares) {
        this.issuer = issuer;
        this.assetName = assetName;
        this.price = price;
        this.numberOfShares = numberOfShares;
    }

    @Generated
    public static EntityOrderBuilder builder() {
        return new EntityOrderBuilder();
    }

    @Generated
    public byte[] getIssuer() {
        return this.issuer;
    }

    @Generated
    public byte[] getAssetName() {
        return this.assetName;
    }

    @Generated
    public long getPrice() {
        return this.price;
    }

    @Generated
    public long getNumberOfShares() {
        return this.numberOfShares;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityOrder)) {
            return false;
        }
        EntityOrder other = (EntityOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPrice() != other.getPrice()) {
            return false;
        }
        if (this.getNumberOfShares() != other.getNumberOfShares()) {
            return false;
        }
        if (!Arrays.equals(this.getIssuer(), other.getIssuer())) {
            return false;
        }
        return Arrays.equals(this.getAssetName(), other.getAssetName());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = this.getPrice();
        result = result * 59 + (int)($price >>> 32 ^ $price);
        long $numberOfShares = this.getNumberOfShares();
        result = result * 59 + (int)($numberOfShares >>> 32 ^ $numberOfShares);
        result = result * 59 + Arrays.hashCode(this.getIssuer());
        result = result * 59 + Arrays.hashCode(this.getAssetName());
        return result;
    }

    @Generated
    public static class EntityOrderBuilder {
        @Generated
        private byte[] issuer;
        @Generated
        private byte[] assetName;
        @Generated
        private long price;
        @Generated
        private long numberOfShares;

        @Generated
        EntityOrderBuilder() {
        }

        @Generated
        public EntityOrderBuilder issuer(byte[] issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public EntityOrderBuilder assetName(byte[] assetName) {
            this.assetName = assetName;
            return this;
        }

        @Generated
        public EntityOrderBuilder price(long price) {
            this.price = price;
            return this;
        }

        @Generated
        public EntityOrderBuilder numberOfShares(long numberOfShares) {
            this.numberOfShares = numberOfShares;
            return this;
        }

        @Generated
        public EntityOrder build() {
            return new EntityOrder(this.issuer, this.assetName, this.price, this.numberOfShares);
        }

        @Generated
        public String toString() {
            return "EntityOrder.EntityOrderBuilder(issuer=" + Arrays.toString(this.issuer) + ", assetName=" + Arrays.toString(this.assetName) + ", price=" + this.price + ", numberOfShares=" + this.numberOfShares + ")";
        }
    }
}

