/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.qx.response;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lombok.Generated;

public class QxFees {
    public static final int SIZE_BYTES = 12;
    private final int assetIssuanceFee;
    private final int transferFee;
    private final int tradeFee;

    public static QxFees fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return QxFees.builder().assetIssuanceFee(buf.getInt()).transferFee(buf.getInt()).tradeFee(buf.getInt()).build();
    }

    public BigDecimal getTradeFeePercentage() {
        return new BigDecimal(this.tradeFee).movePointLeft(7).stripTrailingZeros();
    }

    @Generated
    QxFees(int assetIssuanceFee, int transferFee, int tradeFee) {
        this.assetIssuanceFee = assetIssuanceFee;
        this.transferFee = transferFee;
        this.tradeFee = tradeFee;
    }

    @Generated
    public static QxFeesBuilder builder() {
        return new QxFeesBuilder();
    }

    @Generated
    public int getAssetIssuanceFee() {
        return this.assetIssuanceFee;
    }

    @Generated
    public int getTransferFee() {
        return this.transferFee;
    }

    @Generated
    public int getTradeFee() {
        return this.tradeFee;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QxFees)) {
            return false;
        }
        QxFees other = (QxFees)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAssetIssuanceFee() != other.getAssetIssuanceFee()) {
            return false;
        }
        if (this.getTransferFee() != other.getTransferFee()) {
            return false;
        }
        return this.getTradeFee() == other.getTradeFee();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QxFees;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAssetIssuanceFee();
        result = result * 59 + this.getTransferFee();
        result = result * 59 + this.getTradeFee();
        return result;
    }

    @Generated
    public String toString() {
        return "QxFees(assetIssuanceFee=" + this.getAssetIssuanceFee() + ", transferFee=" + this.getTransferFee() + ", tradeFee=" + this.getTradeFee() + ")";
    }

    @Generated
    public static class QxFeesBuilder {
        @Generated
        private int assetIssuanceFee;
        @Generated
        private int transferFee;
        @Generated
        private int tradeFee;

        @Generated
        QxFeesBuilder() {
        }

        @Generated
        public QxFeesBuilder assetIssuanceFee(int assetIssuanceFee) {
            this.assetIssuanceFee = assetIssuanceFee;
            return this;
        }

        @Generated
        public QxFeesBuilder transferFee(int transferFee) {
            this.transferFee = transferFee;
            return this;
        }

        @Generated
        public QxFeesBuilder tradeFee(int tradeFee) {
            this.tradeFee = tradeFee;
            return this;
        }

        @Generated
        public QxFees build() {
            return new QxFees(this.assetIssuanceFee, this.transferFee, this.tradeFee);
        }

        @Generated
        public String toString() {
            return "QxFees.QxFeesBuilder(assetIssuanceFee=" + this.assetIssuanceFee + ", transferFee=" + this.transferFee + ", tradeFee=" + this.tradeFee + ")";
        }
    }
}

