/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std;

import at.qubic.api.domain.std.Transaction;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SignedTransaction {
    private String transactionHash;
    private final Transaction transaction;
    private byte[] signature;

    protected ByteBuffer toByteBuffer(int capacity) {
        ByteBuffer buf = this.transaction.toByteBuffer(capacity);
        if (buf.hasRemaining()) {
            buf.put(this.signature);
        }
        assert (buf.remaining() == 0);
        return buf;
    }

    public byte[] toBytes() {
        return this.toByteBuffer(this.transaction.getBytesLength() + ArrayUtils.getLength((Object)this.signature)).array();
    }

    public static SignedTransaction fromBytes(byte[] input) {
        ByteBuffer buf = ByteBuffer.wrap(input);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Transaction transaction = Transaction.fromByteBuffer(buf, true);
        Object signedTransaction = ((SignedTransactionBuilder)((SignedTransactionBuilder)SignedTransaction.builder().transaction(transaction)).signature(SignedTransaction.getSignature(buf))).build();
        assert (buf.remaining() == 0);
        return signedTransaction;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("transactionHash", (Object)this.transactionHash).append("signature", this.signature == null ? null : Hex.encodeHexString((byte[])this.signature)).build();
    }

    private static byte[] getSignature(ByteBuffer buf) {
        byte[] arr = new byte[64];
        buf.get(arr);
        return arr;
    }

    @Generated
    protected SignedTransaction(SignedTransactionBuilder<?, ?> b) {
        this.transactionHash = b.transactionHash;
        this.transaction = b.transaction;
        this.signature = b.signature;
    }

    @Generated
    public static SignedTransactionBuilder<?, ?> builder() {
        return new SignedTransactionBuilderImpl();
    }

    @Generated
    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    @Generated
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    @Generated
    public String getTransactionHash() {
        return this.transactionHash;
    }

    @Generated
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Generated
    public byte[] getSignature() {
        return this.signature;
    }

    @Generated
    public static abstract class SignedTransactionBuilder<C extends SignedTransaction, B extends SignedTransactionBuilder<C, B>> {
        @Generated
        private String transactionHash;
        @Generated
        private Transaction transaction;
        @Generated
        private byte[] signature;

        @Generated
        public B transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this.self();
        }

        @Generated
        public B transaction(Transaction transaction) {
            this.transaction = transaction;
            return this.self();
        }

        @Generated
        public B signature(byte[] signature) {
            this.signature = signature;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SignedTransaction.SignedTransactionBuilder(transactionHash=" + this.transactionHash + ", transaction=" + String.valueOf(this.transaction) + ", signature=" + Arrays.toString(this.signature) + ")";
        }
    }

    @Generated
    private static final class SignedTransactionBuilderImpl
    extends SignedTransactionBuilder<SignedTransaction, SignedTransactionBuilderImpl> {
        @Generated
        private SignedTransactionBuilderImpl() {
        }

        @Override
        @Generated
        protected SignedTransactionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SignedTransaction build() {
            return new SignedTransaction(this);
        }
    }
}

