/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    public static final int TRANSACTION_BYTES_LENGTH = 80;
    private final byte[] sourcePublicKey;
    private final byte[] destinationPublicKey;
    private final long amount;
    private final int tick;
    private final short inputType;
    private final short inputSize;
    private final byte[] extraData;

    protected ByteBuffer toByteBuffer(int capacity) {
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.sourcePublicKey);
        buf.put(this.destinationPublicKey);
        buf.putLong(this.amount);
        buf.putInt(this.tick);
        buf.putShort(this.inputType);
        buf.putShort(this.inputSize);
        assert (this.inputSize == this.extraData.length);
        if (this.inputSize > 0) {
            if (this.inputSize != this.extraData.length) {
                log.error("Input size mismatch. Expected [{}] extra data bytes but got [{}].", (Object)this.inputSize, (Object)this.extraData.length);
            }
            buf.put(this.extraData);
        }
        return buf;
    }

    public byte[] toBytes() {
        return this.toByteBuffer(80 + this.inputSize).array();
    }

    protected static Transaction fromByteBuffer(ByteBuffer buf, boolean signed) {
        int signatureSize = signed ? 64 : 0;
        Object tx = ((TransactionBuilder)((TransactionBuilder)((TransactionBuilder)((TransactionBuilder)((TransactionBuilder)((TransactionBuilder)((TransactionBuilder)Transaction.builder().sourcePublicKey(Transaction.getBytesArray(buf, 32))).destinationPublicKey(Transaction.getBytesArray(buf, 32))).amount(buf.getLong())).tick(buf.getInt())).inputType(buf.getShort())).inputSize(buf.getShort())).extraData(Transaction.getBytesArray(buf, buf.remaining() - signatureSize))).build();
        assert (buf.remaining() == signatureSize);
        return tx;
    }

    protected int getBytesLength() {
        return 80 + this.inputSize;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sourcePublicKey", (Object)Hex.encodeHexString((byte[])this.sourcePublicKey)).append("destinationPublicKey", (Object)Hex.encodeHexString((byte[])this.destinationPublicKey)).append("amount", this.amount).append("tick", this.tick).append("inputType", this.inputType).append("inputSize", this.inputSize).build();
    }

    private static byte[] getBytesArray(ByteBuffer buf, int size) {
        byte[] arr = new byte[size];
        buf.get(arr);
        return arr;
    }

    @Generated
    private static byte[] $default$sourcePublicKey() {
        return new byte[32];
    }

    @Generated
    private static byte[] $default$destinationPublicKey() {
        return new byte[32];
    }

    @Generated
    private static short $default$inputType() {
        return 0;
    }

    @Generated
    private static short $default$inputSize() {
        return 0;
    }

    @Generated
    private static byte[] $default$extraData() {
        return new byte[0];
    }

    @Generated
    protected Transaction(TransactionBuilder<?, ?> b) {
        this.sourcePublicKey = b.sourcePublicKey$set ? b.sourcePublicKey$value : Transaction.$default$sourcePublicKey();
        this.destinationPublicKey = b.destinationPublicKey$set ? b.destinationPublicKey$value : Transaction.$default$destinationPublicKey();
        this.amount = b.amount;
        this.tick = b.tick;
        this.inputType = b.inputType$set ? b.inputType$value : Transaction.$default$inputType();
        this.inputSize = b.inputSize$set ? b.inputSize$value : Transaction.$default$inputSize();
        this.extraData = b.extraData$set ? b.extraData$value : Transaction.$default$extraData();
    }

    @Generated
    public static TransactionBuilder<?, ?> builder() {
        return new TransactionBuilderImpl();
    }

    @Generated
    public byte[] getSourcePublicKey() {
        return this.sourcePublicKey;
    }

    @Generated
    public byte[] getDestinationPublicKey() {
        return this.destinationPublicKey;
    }

    @Generated
    public long getAmount() {
        return this.amount;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public short getInputType() {
        return this.inputType;
    }

    @Generated
    public short getInputSize() {
        return this.inputSize;
    }

    @Generated
    public byte[] getExtraData() {
        return this.extraData;
    }

    @Generated
    public static abstract class TransactionBuilder<C extends Transaction, B extends TransactionBuilder<C, B>> {
        @Generated
        private boolean sourcePublicKey$set;
        @Generated
        private byte[] sourcePublicKey$value;
        @Generated
        private boolean destinationPublicKey$set;
        @Generated
        private byte[] destinationPublicKey$value;
        @Generated
        private long amount;
        @Generated
        private int tick;
        @Generated
        private boolean inputType$set;
        @Generated
        private short inputType$value;
        @Generated
        private boolean inputSize$set;
        @Generated
        private short inputSize$value;
        @Generated
        private boolean extraData$set;
        @Generated
        private byte[] extraData$value;

        @Generated
        public B sourcePublicKey(byte[] sourcePublicKey) {
            this.sourcePublicKey$value = sourcePublicKey;
            this.sourcePublicKey$set = true;
            return this.self();
        }

        @Generated
        public B destinationPublicKey(byte[] destinationPublicKey) {
            this.destinationPublicKey$value = destinationPublicKey;
            this.destinationPublicKey$set = true;
            return this.self();
        }

        @Generated
        public B amount(long amount) {
            this.amount = amount;
            return this.self();
        }

        @Generated
        public B tick(int tick) {
            this.tick = tick;
            return this.self();
        }

        @Generated
        public B inputType(short inputType) {
            this.inputType$value = inputType;
            this.inputType$set = true;
            return this.self();
        }

        @Generated
        public B inputSize(short inputSize) {
            this.inputSize$value = inputSize;
            this.inputSize$set = true;
            return this.self();
        }

        @Generated
        public B extraData(byte[] extraData) {
            this.extraData$value = extraData;
            this.extraData$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Transaction.TransactionBuilder(sourcePublicKey$value=" + Arrays.toString(this.sourcePublicKey$value) + ", destinationPublicKey$value=" + Arrays.toString(this.destinationPublicKey$value) + ", amount=" + this.amount + ", tick=" + this.tick + ", inputType$value=" + this.inputType$value + ", inputSize$value=" + this.inputSize$value + ", extraData$value=" + Arrays.toString(this.extraData$value) + ")";
        }
    }

    @Generated
    private static final class TransactionBuilderImpl
    extends TransactionBuilder<Transaction, TransactionBuilderImpl> {
        @Generated
        private TransactionBuilderImpl() {
        }

        @Override
        @Generated
        protected TransactionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Transaction build() {
            return new Transaction(this);
        }
    }
}

