/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import at.qubic.api.util.AssetUtil;
import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AssetIssuance {
    private final byte[] publicKey;
    private final byte type;
    private final byte[] name;
    private final byte numberOfDecimalPlaces;
    private final byte[] unitOfMeasurement;

    public static AssetIssuance fromByteBuffer(ByteBuffer buf) {
        return AssetIssuance.builder().publicKey(BufferUtil.getByteArray(buf, 32)).type(buf.get()).name(BufferUtil.getByteArray(buf, 7)).numberOfDecimalPlaces(buf.get()).unitOfMeasurement(BufferUtil.getByteArray(buf, 7)).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("publicKey", this.publicKey == null ? null : Hex.encodeHexString((byte[])this.publicKey)).append("type", this.type).append("name", (Object)AssetUtil.nameToString(this.name)).append("numberOfDecimalPlaces", this.numberOfDecimalPlaces).append("unitOfMeasurement", (Object)Arrays.toString(this.unitOfMeasurement)).build();
    }

    @Generated
    AssetIssuance(byte[] publicKey, byte type, byte[] name, byte numberOfDecimalPlaces, byte[] unitOfMeasurement) {
        this.publicKey = publicKey;
        this.type = type;
        this.name = name;
        this.numberOfDecimalPlaces = numberOfDecimalPlaces;
        this.unitOfMeasurement = unitOfMeasurement;
    }

    @Generated
    public static AssetIssuanceBuilder builder() {
        return new AssetIssuanceBuilder();
    }

    @Generated
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public byte getType() {
        return this.type;
    }

    @Generated
    public byte[] getName() {
        return this.name;
    }

    @Generated
    public byte getNumberOfDecimalPlaces() {
        return this.numberOfDecimalPlaces;
    }

    @Generated
    public byte[] getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetIssuance)) {
            return false;
        }
        AssetIssuance other = (AssetIssuance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getNumberOfDecimalPlaces() != other.getNumberOfDecimalPlaces()) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        if (!Arrays.equals(this.getName(), other.getName())) {
            return false;
        }
        return Arrays.equals(this.getUnitOfMeasurement(), other.getUnitOfMeasurement());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetIssuance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        result = result * 59 + this.getNumberOfDecimalPlaces();
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        result = result * 59 + Arrays.hashCode(this.getName());
        result = result * 59 + Arrays.hashCode(this.getUnitOfMeasurement());
        return result;
    }

    @Generated
    public static class AssetIssuanceBuilder {
        @Generated
        private byte[] publicKey;
        @Generated
        private byte type;
        @Generated
        private byte[] name;
        @Generated
        private byte numberOfDecimalPlaces;
        @Generated
        private byte[] unitOfMeasurement;

        @Generated
        AssetIssuanceBuilder() {
        }

        @Generated
        public AssetIssuanceBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public AssetIssuanceBuilder type(byte type) {
            this.type = type;
            return this;
        }

        @Generated
        public AssetIssuanceBuilder name(byte[] name) {
            this.name = name;
            return this;
        }

        @Generated
        public AssetIssuanceBuilder numberOfDecimalPlaces(byte numberOfDecimalPlaces) {
            this.numberOfDecimalPlaces = numberOfDecimalPlaces;
            return this;
        }

        @Generated
        public AssetIssuanceBuilder unitOfMeasurement(byte[] unitOfMeasurement) {
            this.unitOfMeasurement = unitOfMeasurement;
            return this;
        }

        @Generated
        public AssetIssuance build() {
            return new AssetIssuance(this.publicKey, this.type, this.name, this.numberOfDecimalPlaces, this.unitOfMeasurement);
        }

        @Generated
        public String toString() {
            return "AssetIssuance.AssetIssuanceBuilder(publicKey=" + Arrays.toString(this.publicKey) + ", type=" + this.type + ", name=" + Arrays.toString(this.name) + ", numberOfDecimalPlaces=" + this.numberOfDecimalPlaces + ", unitOfMeasurement=" + Arrays.toString(this.unitOfMeasurement) + ")";
        }
    }
}

