/*
 * Decompiled with CFR 0.152.
 */
package at.qubic.api.domain.std.response;

import at.qubic.api.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AssetPossession {
    private final byte[] publicKey;
    private final byte type;
    private final byte padding;
    private final short managingContractIndex;
    private final int ownershipIndex;
    private final long numberOfUnits;

    public static AssetPossession fromByteBuffer(ByteBuffer buf) {
        return AssetPossession.builder().publicKey(BufferUtil.getByteArray(buf, 32)).type(buf.get()).padding(buf.get()).managingContractIndex(buf.getShort()).ownershipIndex(buf.getInt()).numberOfUnits(buf.getLong()).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("publicKey", this.publicKey == null ? null : Hex.encodeHexString((byte[])this.publicKey)).append("type", this.type).append("managingContractIndex", this.managingContractIndex).append("ownershipIndex", this.ownershipIndex).append("numberOfUnits", this.numberOfUnits).build();
    }

    @Generated
    AssetPossession(byte[] publicKey, byte type, byte padding, short managingContractIndex, int ownershipIndex, long numberOfUnits) {
        this.publicKey = publicKey;
        this.type = type;
        this.padding = padding;
        this.managingContractIndex = managingContractIndex;
        this.ownershipIndex = ownershipIndex;
        this.numberOfUnits = numberOfUnits;
    }

    @Generated
    public static AssetPossessionBuilder builder() {
        return new AssetPossessionBuilder();
    }

    @Generated
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public byte getType() {
        return this.type;
    }

    @Generated
    public byte getPadding() {
        return this.padding;
    }

    @Generated
    public short getManagingContractIndex() {
        return this.managingContractIndex;
    }

    @Generated
    public int getOwnershipIndex() {
        return this.ownershipIndex;
    }

    @Generated
    public long getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetPossession)) {
            return false;
        }
        AssetPossession other = (AssetPossession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getPadding() != other.getPadding()) {
            return false;
        }
        if (this.getManagingContractIndex() != other.getManagingContractIndex()) {
            return false;
        }
        if (this.getOwnershipIndex() != other.getOwnershipIndex()) {
            return false;
        }
        if (this.getNumberOfUnits() != other.getNumberOfUnits()) {
            return false;
        }
        return Arrays.equals(this.getPublicKey(), other.getPublicKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetPossession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        result = result * 59 + this.getPadding();
        result = result * 59 + this.getManagingContractIndex();
        result = result * 59 + this.getOwnershipIndex();
        long $numberOfUnits = this.getNumberOfUnits();
        result = result * 59 + (int)($numberOfUnits >>> 32 ^ $numberOfUnits);
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        return result;
    }

    @Generated
    public static class AssetPossessionBuilder {
        @Generated
        private byte[] publicKey;
        @Generated
        private byte type;
        @Generated
        private byte padding;
        @Generated
        private short managingContractIndex;
        @Generated
        private int ownershipIndex;
        @Generated
        private long numberOfUnits;

        @Generated
        AssetPossessionBuilder() {
        }

        @Generated
        public AssetPossessionBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public AssetPossessionBuilder type(byte type) {
            this.type = type;
            return this;
        }

        @Generated
        public AssetPossessionBuilder padding(byte padding) {
            this.padding = padding;
            return this;
        }

        @Generated
        public AssetPossessionBuilder managingContractIndex(short managingContractIndex) {
            this.managingContractIndex = managingContractIndex;
            return this;
        }

        @Generated
        public AssetPossessionBuilder ownershipIndex(int ownershipIndex) {
            this.ownershipIndex = ownershipIndex;
            return this;
        }

        @Generated
        public AssetPossessionBuilder numberOfUnits(long numberOfUnits) {
            this.numberOfUnits = numberOfUnits;
            return this;
        }

        @Generated
        public AssetPossession build() {
            return new AssetPossession(this.publicKey, this.type, this.padding, this.managingContractIndex, this.ownershipIndex, this.numberOfUnits);
        }

        @Generated
        public String toString() {
            return "AssetPossession.AssetPossessionBuilder(publicKey=" + Arrays.toString(this.publicKey) + ", type=" + this.type + ", padding=" + this.padding + ", managingContractIndex=" + this.managingContractIndex + ", ownershipIndex=" + this.ownershipIndex + ", numberOfUnits=" + this.numberOfUnits + ")";
        }
    }
}

